<?php

namespace App\Exports;

use App\Models\User;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class EmployeeConveyanceMonthSummaryExport implements FromView
{
    public User $employee;
    public array $monthsData;

    public function __construct(User $employee, array $monthsData)
    {
        $this->employee   = $employee;
        $this->monthsData = $monthsData;
    }

    public function view(): View
    {
        // compute maxDays for header
        $maxDays = 0;
        foreach ($this->monthsData as $month) {
            $maxDays = max($maxDays, $month['days_in_month']);
        }
        if ($maxDays === 0) {
            $maxDays = 31;
        }

        return view('admin.conveyance.exports.employee_month_summary', [
            'employee'   => $this->employee,
            'monthsData' => $this->monthsData,
            'maxDays'    => $maxDays,
        ]);
    }
}
