<?php

namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithTitle;

class EmployeeMasterExport implements FromView, ShouldAutoSize, WithTitle
{
    protected $viewData;
    protected $currentMonthLabel;

    public function __construct(array $viewData, string $currentMonthLabel)
    {
        $this->viewData          = $viewData;
        $this->currentMonthLabel = $currentMonthLabel;
    }

    public function view(): View
    {
        // simple export view (we'll create it next)
        return view('admin.conveyance.employee_master_export', $this->viewData);
    }

    public function title(): string
    {
        return $this->currentMonthLabel;
    }
}
