<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Leave;

class AdminLeaveController extends Controller
{
    public function index(Request $request)
    {
        $query = Leave::with('employee.user');

        if ($request->has('status') && $request->status != '') {
            $query->where('status', $request->status);
        }

        $leaves = $query->orderBy('created_at', 'desc')->paginate(10);

        return view('admin.leaves.index', compact('leaves'));
    }

    public function updateStatus(Request $request, Leave $leave)
    {
        $request->validate([
            'status' => 'required|in:approved,rejected',
            'admin_remark' => 'nullable|string',
        ]);

        $leave->status = $request->status;
        $leave->admin_remark = $request->admin_remark;
        $leave->save();

        return redirect()->back()->with('success', 'Leave status updated successfully.');
    }
}
