<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Session;
use Illuminate\Http\Request;

class AdminSessionController extends Controller
{
    public function index()
    {
        $sessions = Session::orderBy('start_date','desc')->get();
        return view('admin.sessions.index', compact('sessions'));
    }

    public function create()
    {
        return view('admin.sessions.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name'=>'required|unique:financial_sessions,name',
            'start_date'=>'required|date',
            'end_date'=>'required|date|after:start_date',
        ]);

        Session::create([
            'name'=>$request->name,
            'start_date'=>$request->start_date,
            'end_date'=>$request->end_date,
            'is_active'=>false
        ]);

        return redirect()->route('admin.sessions.index')
            ->with('success','Financial session created.');
    }

    public function activate($id)
    {
        Session::query()->update(['is_active'=>false]);
        Session::where('id',$id)->update(['is_active'=>true]);

        return back()->with('success','Session activated.');
    }
}
