<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Client;
use Illuminate\Http\Request;

class ClientController extends Controller
{
    /**
     * Show list of clients.
     */
    public function index()
    {
        $clients = Client::orderBy('name')->get();

        return view('admin.clients.index', compact('clients'));
    }

    /**
     * Show create form.
     */
    public function create()
    {
        return view('admin.clients.create');
    }

    /**
     * Store new client.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'code' => ['nullable', 'string', 'max:50'],
            'city' => ['nullable', 'string', 'max:255'],
            'notes' => ['nullable', 'string'],
            'is_active' => ['nullable', 'boolean'],
        ]);

        $validated['is_active'] = $request->has('is_active');

        Client::create($validated);

        return redirect()
            ->route('admin.clients.index')
            ->with('success', 'Client created successfully.');
    }

    /**
     * Toggle active/inactive status.
     */
    public function toggleStatus(Client $client)
    {
        $client->is_active = ! $client->is_active;
        $client->save();

        return redirect()
            ->route('admin.clients.index')
            ->with('success', 'Client status updated.');
    }
}
