<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ClientRequest;
use Illuminate\Http\Request;

class ClientRequestController extends Controller
{
    public function index()
    {
        $requests = ClientRequest::with('user')
            ->orderByRaw("FIELD(status, 'pending', 'approved', 'rejected')")
            ->orderBy('created_at', 'desc')
            ->paginate(20);

        $pendingCount = ClientRequest::where('status', 'pending')->count();

        return view('admin.client_requests.index', compact('requests', 'pendingCount'));
    }

    public function updateStatus(Request $request, ClientRequest $clientRequest)
    {
        $data = $request->validate([
            'status' => ['required', 'in:pending,approved,rejected'],
        ]);

        $clientRequest->update([
            'status' => $data['status'],
        ]);

        return redirect()
            ->route('admin.client-requests.index')
            ->with('success', 'Client request status updated.');
    }
}
