<?php

namespace App\Http\Controllers\Employee;

use App\Http\Controllers\Controller;
use App\Models\Conveyance;
use App\Models\Session;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $activeSession = Session::active();
        $today = Carbon::today();

        // Same window logic
        if ($today->day <= 10) {
            $targetMonth = $today->copy()->subMonthNoOverflow();
        } else {
            $targetMonth = $today->copy();
        }

        $monthStart = $targetMonth->copy()->startOfMonth();
        $monthEnd = $targetMonth->copy()->endOfMonth();
        $currentMonthLabel = $targetMonth->format('F Y');

        // Get all rows first (same as conveyance index)
        $conveyances = Conveyance::where('user_id', $user->id)
            ->whereBetween('date', [$monthStart, $monthEnd])
            ->get();

        // Compute totals using accessor
        $monthTotalSubmitted = $conveyances
            ->where('status', 'submitted')
            ->sum(fn($c) => $c->total_amount);

        $monthTotalDraft = $conveyances
            ->where('status', 'draft')
            ->sum(fn($c) => $c->total_amount);

        // Fetch History Summary (All submitted months)
        $historySummary = Conveyance::where('user_id', $user->id)
            ->where('status', 'submitted')
            ->get()
            ->groupBy(function ($c) {
                return $c->date->format('Y-m');
            })
            ->map(function ($rows, $ym) {
                return [
                    'month_key' => $ym,
                    'month_label' => Carbon::createFromFormat('Y-m', $ym)->format('M y'),
                    'total' => $rows->sum(fn($c) => $c->total_amount)
                ];
            })
            ->sortByDesc('month_key');

        // placeholders
        $pendingApproval = 0;
        $lastPayout = 0;

        return view('employee.dashboard', compact(
            'activeSession',
            'currentMonthLabel',
            'monthStart',
            'monthEnd',
            'monthTotalSubmitted',
            'monthTotalDraft',
            'historySummary',
            'pendingApproval',
            'lastPayout'
        ));
    }
}
