<?php

namespace App\Http\Controllers\Employee;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Leave;

class LeaveController extends Controller
{
    public function index(Request $request)
    {
        $leaves = Leave::where('employee_id', auth()->user()->employee->id)
            ->orderBy('created_at', 'desc')
            ->get();
        return view('employee.leaves.index', compact('leaves'));
    }

    public function create()
    {
        return view('employee.leaves.create');
    }


    public function store(Request $request){
        $request->validate([
            'start_date' => 'required|date',
            'end_date' => 'required|date|after_or_equal:start_date',
            'approved_by' => 'nullable|string|max:255',
            'reason' => 'nullable|string',
        ]);
        $leave = new Leave();
        $leave->employee_id = auth()->user()->employee->id;
        $leave->start_date = $request->start_date;
        $leave->end_date = $request->end_date;
        $leave->approved_by = $request->approved_by;
        $leave->reason = $request->reason;
        $leave->status = 'pending';
        $leave->save();
        return redirect()->route('employee.leaves.index')->with('success', 'Leave application submitted successfully.');    
    }

    


}
