<?php

namespace App\Mail;

use App\Models\ClientRequest;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class NewClientRequestMail extends Mailable
{
    use Queueable, SerializesModels;

    public ClientRequest $clientRequest;

    /**
     * Create a new message instance.
     */
    public function __construct(ClientRequest $clientRequest)
    {
        $this->clientRequest = $clientRequest;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject('New Client Request from Employee')
            ->view('emails.client_requests.new');
    }
}
