<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Conveyance extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'session_id',
        'date',
        'from_location',
        'to_location',
        'client_id',
        'mode',
        'amount',
        'return_amount',
        'return_remarks',
        'remarks',
        'is_return',
        'status',
    ];

    protected $casts = [
        'date' => 'date',
        'is_return' => 'boolean',
        'amount' => 'decimal:2',
        'return_amount' => 'decimal:2',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function session()
    {
        return $this->belongsTo(Session::class);
    }

    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    /**
     * Calculate total cost (onward + return if applicable).
     */
    public function getTotalAmountAttribute()
    {
        $onward = (float) $this->amount;
        if ($this->is_return) {
            $return = $this->return_amount !== null
                ? (float) $this->return_amount
                : $onward;
            return $onward + $return;
        }
        return $onward;
    }
}
