<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Employee extends Model
{
    protected $fillable = ['emp_code', 'name', 'email', 'phone', 'is_active'];

    /**
     * Sessions pivot relation.
     */
    public function sessions(): BelongsToMany
    {
        return $this->belongsToMany(Session::class, 'employee_session')
            ->withPivot('joined_at', 'is_active_for_session')
            ->withTimestamps();
    }

    /**
     * Link to the users table (if you create a user for this employee).
     */
    public function user(): HasOne
    {
        return $this->hasOne(User::class, 'employee_id', 'id');
    }
}
