<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Expense extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'employee_id',
        'financial_session_id',
        'expense_group_id',
        'group',
        'expense_date',
        'party_name',
        'purpose',
        'amount',
        'proof_path',
        'proof_original_name',
        'proof_paths',
        'is_approved',
        'admin_comment',
    ];

    protected $casts = [
        'expense_date' => 'date',
        'is_approved' => 'boolean',
        'amount' => 'decimal:2',
        'proof_paths' => 'array',
    ];

    

    public function user(): BelongsTo
    {
        return $this->belongsTo(\App\Models\User::class);
    }

    public function employee(): BelongsTo
    {
        return $this->belongsTo(\App\Models\Employee::class);
    }
    public function expenseGroup()
    {
        return $this->belongsTo(ExpenseGroup::class, 'expense_group_id');
    }

   public function session()
    {
        return $this->belongsTo(Session::class);
    }
 
 


}
