<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Leave extends Model
{
    protected $appends = ['total_days'];
    public function getTotalDaysAttribute()
    {
        if ($this->start_date && $this->end_date) {
            return Carbon::parse($this->start_date)
                ->diffInDays(Carbon::parse($this->end_date)) + 1;
        }

        return 0;
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }
}
