<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Session extends Model
{
    protected $table = 'financial_sessions';

    protected $fillable = ['name','start_date','end_date','is_active'];
    protected $casts = [
        'start_date'=>'date',
        'end_date'=>'date',
        'is_active'=>'boolean'
    ];

    public function employees()
    {
        return $this->belongsToMany(Employee::class, 'employee_session')
            ->withPivot('joined_at','is_active_for_session')
            ->withTimestamps();
    }

    public static function active()
    {
        return static::where('is_active', true)->first();
    }

    public static function forDate($date)
    {
        return static::where('start_date','<=',$date)
            ->where('end_date','>=',$date)
            ->first();
    }
}
