<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('employee_session', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->constrained()->onDelete('cascade');
            $table->foreignId('session_id')
                ->constrained('financial_sessions')
                ->onDelete('cascade');

            $table->date('joined_at')->nullable();
            $table->boolean('is_active_for_session')->default(true);

            $table->timestamps();
            $table->unique(['employee_id', 'session_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('employee_session');
    }
};
