<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('clients', function (Blueprint $table) {
            $table->id();
            $table->string('name');                 // Client name
            $table->string('code')->nullable();     // Optional short code
            $table->string('city')->nullable();     // City / Location
            $table->boolean('is_active')->default(true); // Only active clients in dropdown
            $table->text('notes')->nullable();      // Optional internal notes
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('clients');
    }
};
