<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('conveyances', function (Blueprint $table) {
            $table->id();

            $table->foreignId('user_id')
                ->constrained()
                ->cascadeOnDelete();

            $table->foreignId('session_id')
                ->nullable()
                ->constrained('financial_sessions')
                ->nullOnDelete();

            $table->date('date');

            $table->string('from_location');
            $table->string('to_location');

            $table->foreignId('client_id')
                ->nullable()
                ->constrained('clients')
                ->nullOnDelete();

            $table->enum('status', ['draft', 'submitted'])
                ->default('submitted');

            $table->string('mode')->nullable();

            // Onward fare (always required)
            $table->decimal('amount', 10, 2);

            // NEW: Custom return fare (if null → same as onward, if set → use this)
            $table->decimal('return_amount', 10, 2)->nullable();

            $table->string('remarks')->nullable();

            // NEW: Separate remark for return leg
            $table->string('return_remarks')->nullable();

            $table->boolean('is_return')->default(false);

            $table->timestamps();

            $table->index(['user_id', 'date']);
            $table->index('session_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('conveyances');
    }
};
