<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('expense_groups', function (Blueprint $table) {
            $table->id();

            // Employee user who owns this group
            $table->foreignId('user_id')
                ->constrained('users')
                ->onDelete('cascade');

            // Group name: Travel, Food, Client Visit, etc.
            $table->string('name');

            // Optionally deactivate instead of delete
            $table->boolean('is_active')->default(true);

            $table->timestamps();

            // Same user cannot have two groups with same name
            $table->unique(['user_id', 'name']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('expense_groups');
    }
};
