<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('expenses', function (Blueprint $table) {
            $table->id();

            // User who created the expense (employee user)
            $table->foreignId('user_id')
                ->constrained('users')
                ->onDelete('cascade');

            // Optional direct link to employees table
            $table->foreignId('employee_id')
                ->nullable()
                ->constrained('employees')
                ->onDelete('set null');

            // Financial session (year-wise)
            $table->foreignId('financial_session_id')
                ->constrained('financial_sessions')
                ->onDelete('cascade');

            // NEW: dynamic group (FK to expense_groups)
            $table->foreignId('expense_group_id')
                ->nullable()
                ->constrained('expense_groups')
                ->nullOnDelete();

            // Optional: keep text column also (for reports / backup)
            $table->string('group')->nullable();

            $table->date('expense_date');
            $table->string('party_name')->nullable();
            $table->text('purpose')->nullable();
            $table->decimal('amount', 14, 2)->default(0);

            $table->string('proof_original_name')->nullable(); // original filename
            $table->json('proof_paths')->nullable();

            $table->boolean('is_approved')->default(false); // admin approval flag
            $table->text('admin_comment')->nullable();

            $table->timestamps();

            $table->index(['user_id', 'financial_session_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('expenses');
    }
};
