<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up(): void
{
    Schema::create('leaves', function (Blueprint $table) {
        $table->id();
        $table->unsignedBigInteger('employee_id');
        $table->foreign('employee_id')->references('id')->on('employees')->cascadeOnDelete();
        $table->date('start_date');
        $table->date('end_date');
        $table->string('approved_by')->nullable();
        $table->text('reason')->nullable();
        $table->text('admin_remark')->nullable();
        $table->string('status')->default('pending');
        $table->index('status');
        $table->timestamps();
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('leaves');
    }
};
