<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Session;

class InitialSetupSeeder extends Seeder
{
    public function run(): void
    {
        // 1) Create Admin Users (OTP only, so password not required)
        User::firstOrCreate(
            ['email' => 'connectwithsartaj@gmail.com'],
            [
                'name' => 'PAC Admin',
                'phone' => null,           // future: add phone if needed
                'role' => 'admin',
                'password' => null,        // OTP based login
                'employee_id' => null
            ]
        );

        // New admin as requested
        User::firstOrCreate(
            ['email' => 'pkagg123@gmail.com'],
            [
                'name' => 'PAC Admin 2',
                'phone' => null,
                'role' => 'admin',
                'password' => null,
                'employee_id' => null
            ]
        );

        // 2) Create default Financial Session (active)
        // NOTE: Session model already mapped to financial_sessions table
        Session::firstOrCreate(
            ['name' => '2025-2026'],
            [
                'start_date' => '2025-04-01',
                'end_date'   => '2026-03-31',
                'is_active'  => true
            ]
        );

        // If multiple sessions active accidentally, this is a safeguard:
        Session::where('name', '!=', '2025-2026')->update(['is_active' => false]);
    }
}
