<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Employee;
use App\Models\User;
use App\Models\Session;   // <--- IMPORTANT
use Illuminate\Support\Facades\Hash;

class RealEmployeesSeeder extends Seeder
{
    public function run(): void
    {
        // 1) Make sure we have an ACTIVE financial session
        //    If you want a specific year, change these values.
        $activeSession = Session::active();

        if (! $activeSession) {
            // Example: current financial year 2025-2026 (adjust as you like)
            $activeSession = Session::create([
                'name'       => '2025-2026',
                'start_date' => '2025-04-01',
                'end_date'   => '2026-03-31',
                'is_active'  => true,
            ]);
        }

        $employees = [
            ['name' => 'Prabhat Kumar Jha',   'email' => 'jhaaprabhat2912@gmail.com',      'phone' => '9205819826'],
            ['name' => 'Maya Durgapal',       'email' => 'sania8565@gmail.com',            'phone' => '9625728268'],
            ['name' => 'Kritik Sharma',       'email' => 'auditkritik@gmail.com',          'phone' => '9899075788'],
            ['name' => 'Deepak Yadav',        'email' => 'dy2330062@gmail.com',            'phone' => '9871368715'],
            ['name' => 'Shubham Kumar',       'email' => 'shubhamkr6660@gmail.com',        'phone' => '8800169354'],
            ['name' => 'Hemant Kumar',        'email' => 'hkpawar34@gmail.com',            'phone' => '9990676452'],
            ['name' => 'Shital Kumar Jha',    'email' => 'auditorshital@yahoo.co.in',      'phone' => '9971558683'],
            ['name' => 'Nishant Kumar',       'email' => 'nishantraj1503@gmail.com',       'phone' => '6204933667'],
            ['name' => 'Ajay Kumar',          'email' => 'ajay.kumarsk88@gmail.com',       'phone' => '9650455846'],
            ['name' => 'Harpreet Kaur',       'email' => 'bharpreet040@gmail.com',         'phone' => '8447181878'],
            ['name' => 'Anish Mehta',         'email' => 'mehta4888@gmail.com',            'phone' => '8505945585'],
            ['name' => 'Mohit Gupta',         'email' => 'mohitvijay1310@gmail.com',       'phone' => '8826945413'],
            ['name' => 'Abhishek Rajput',     'email' => 'abhishek.rajput861@gmail.com',   'phone' => '9873737076'],
            ['name' => 'Anant Mishra',        'email' => 'anantmishra333@gmail.com',       'phone' => '7523932593'],
            ['name' => 'Sumit Singh',         'email' => 'thakursumitsingh50@gmail.com',   'phone' => '7703866785'],
            ['name' => 'Rohit Gupta',         'email' => 'rohitgupta07802@gmail.com',      'phone' => '8800890287'],
            ['name' => 'Manish Sharma',       'email' => 'sharmaji897@gmail.com',          'phone' => '9910220041'],
            ['name' => 'Aman Shukla',         'email' => 'amanshukla7388201063@gmail.com', 'phone' => '9839287404'],
            ['name' => 'RAMAN',               'email' => 'Ramansinghgautam12@gmail.com',   'phone' => '7503407781'],
            ['name' => 'SACHIN',              'email' => 'sachin.verma3112@gmail.com',     'phone' => '9716486864'],
            ['name' => 'JAYA',                'email' => 'Jayasharma1229@gmail.com',       'phone' => '7764944300'],
            ['name' => 'Lokesh Arora',        'email' => 'audit.lokesharora@gmail.com',    'phone' => '9716592216'],
        ];

        foreach ($employees as $emp) {
            // 2) Create or update employee (unique by email)
            $employee = Employee::updateOrCreate(
                ['email' => $emp['email']],
                [
                    'name'      => $emp['name'],
                    'phone'     => $emp['phone'],
                    'is_active' => true,
                ]
            );

            // 3) Create/update linked user
            User::updateOrCreate(
                ['email' => $emp['email']],
                [
                    'name'        => $emp['name'],
                    'phone'       => $emp['phone'],
                    // use null for OTP-based flow OR set a default password:
                    // 'password' => Hash::make('password123'),
                    'password'    => null,
                    'role'        => 'employee',
                    'employee_id' => $employee->id,
                ]
            );

            // 4) Attach employee to the active financial session
            if ($activeSession) {
                $employee->sessions()->syncWithoutDetaching([
                    $activeSession->id => [
                        'joined_at'            => now()->toDateString(),
                        'is_active_for_session'=> true,
                    ],
                ]);
            }
        }
    }
}
