<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class VerificationConveyanceSeeder extends Seeder
{
    public function run()
    {
        $userId = 32; // personal.sartajali@gmail.com
        $sessionId = 1; // Assuming Session 1 is active

        // Clear existing for this user to avoid dupe clutter during test
        DB::table('conveyances')->where('user_id', $userId)->delete();

        // 1. History: November 2025 (Submitted)
        $this->createMonthData($userId, $sessionId, '2025-11', 'submitted');

        // 2. History: December 2025 (Submitted)
        $this->createMonthData($userId, $sessionId, '2025-12', 'submitted');

        // 3. Current: January 2026 (Drafts - assuming current date is Jan 2026)
        // Note: As per logic, if today is Jan 5, window is Dec. If today is Jan 11, window is Jan.
        // Let's create some JAN drafts anyway.
        $this->createMonthData($userId, $sessionId, '2026-01', 'draft', 3);

        echo "Seeder completed for User ID: $userId\n";
    }

    private function createMonthData($userId, $sessionId, $yearMonth, $status, $count = 5)
    {
        $startDate = Carbon::parse($yearMonth . '-01');
        $daysInMonth = $startDate->daysInMonth;

        for ($i = 0; $i < $count; $i++) {
            $date = $startDate->copy()->addDays(rand(0, $daysInMonth - 1));
            // Skip weekends for realism
            if ($date->isWeekend()) {
                $date->addDays(2);
            }
            if ($date->month != $startDate->month) {
                $date->subDays(5);
            }

            $amount = rand(50, 500);
            $isReturn = rand(0, 1) === 1;
            $returnAmount = $isReturn ? $amount : null;
            $total = $amount + ($isReturn ? $returnAmount : 0);

            DB::table('conveyances')->insert([
                'user_id' => $userId,
                'session_id' => $sessionId,
                'date' => $date->toDateString(),
                'from_location' => 'Office',
                'to_location' => 'Client Site ' . chr(65 + $i),
                'mode' => ['Bike', 'Auto', 'Cab', 'Metro'][rand(0, 3)],
                'amount' => $amount,
                'is_return' => $isReturn,
                'return_amount' => $returnAmount,
                'total_amount' => $total,
                'status' => $status,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
