<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Conveyance;
use Carbon\Carbon;

class VerificationConveyanceSeederV2 extends Seeder
{
    public function run()
    {
        $userId = 32; // personal.sartajali@gmail.com
        $sessionId = 1;

        // Clear existing
        Conveyance::where('user_id', $userId)->delete();

        // 1. November 2025 (Submitted)
        $this->createMonthData($userId, $sessionId, '2025-11', 'submitted');

        // 2. December 2025 (Submitted)
        $this->createMonthData($userId, $sessionId, '2025-12', 'submitted');

        // 3. January 2026 (Draft)
        $this->createMonthData($userId, $sessionId, '2026-01', 'draft', 3);

        echo "V2 Seeder completed.\n";
    }

    private function createMonthData($userId, $sessionId, $yearMonth, $status, $count = 5)
    {
        $startDate = Carbon::parse($yearMonth . '-01');
        $daysInMonth = $startDate->daysInMonth;

        for ($i = 0; $i < $count; $i++) {
            $date = $startDate->copy()->addDays(rand(0, $daysInMonth - 1));
            if ($date->isWeekend())
                $date->addDays(2);

            $amount = rand(50, 500);
            $isReturn = rand(0, 1) === 1;

            Conveyance::create([
                'user_id' => $userId,
                'session_id' => $sessionId,
                'date' => $date->toDateString(),
                'from_location' => 'Office',
                'to_location' => 'Client ' . chr(65 + $i),
                'mode' => ['Bike', 'Auto', 'Cab'][rand(0, 2)],
                'amount' => $amount,
                'is_return' => $isReturn,
                'return_amount' => $isReturn ? $amount : null,
                'status' => $status,
                'remarks' => 'Seeded Data'
            ]);
        }
    }
}
