$activeSession = \App\Models\Session::find(1);
$sessionStart = \Carbon\Carbon::parse($activeSession->start_date)->startOfMonth();
$sessionEnd = \Carbon\Carbon::parse($activeSession->end_date)->endOfMonth();

echo "Session: " . $sessionStart->toDateString() . " to " . $sessionEnd->toDateString() . "\n";

$raw = \App\Models\Conveyance::select([
'user_id',
\Illuminate\Support\Facades\DB::raw('DATE_FORMAT(date, "%Y-%m") as ym'),
\Illuminate\Support\Facades\DB::raw('SUM(amount + CASE WHEN is_return = 1 THEN COALESCE(return_amount, amount) ELSE 0
END) as total_amount'),
])
->whereBetween('date', [$sessionStart->toDateString(), $sessionEnd->toDateString()])
->where('session_id', $activeSession->id)
->where('status', 'submitted')
->groupBy('user_id', 'ym')
->get();

echo "Raw Count: " . $raw->count() . "\n";
foreach($raw as $r) {
echo "UID: " . $r->user_id . " | YM: " . $r->ym . " | Total: " . $r->total_amount . "\n";
}

// Check sample data types
$sample = \App\Models\Conveyance::where('status', 'submitted')->first();
echo "Sample Amount Type: " . gettype($sample->amount) . " Value: " . $sample->amount . "\n";
echo "Sample Return Amount Type: " . gettype($sample->return_amount) . " Value: " . $sample->return_amount . "\n";
exit;