@extends('layouts.admin')

@section('page-title', 'Client Requests')
@section('page-subtitle', 'New client requests raised by employees')

@section('content')
    <div class="mb-6">
        <h1 class="text-xl font-bold">Client Requests</h1>
        <p class="text-sm text-gray-500 mt-1">
            Pending requests: <span class="font-semibold">{{ $pendingCount }}</span>
        </p>
    </div>

    @if(session('success'))
        <div class="mb-4 px-4 py-2 rounded-xl bg-emerald-50 text-emerald-800 text-sm">
            {{ session('success') }}
        </div>
    @endif

    <div class="bg-white rounded-2xl shadow border border-slate-200">
        <table class="w-full text-sm">
            <thead class="bg-slate-50 text-xs uppercase text-gray-500">
                <tr>
                    <th class="px-4 py-2 text-left">Employee</th>
                    <th class="px-4 py-2 text-left">Client Name</th>
                    <th class="px-4 py-2 text-left">Notes</th>
                    <th class="px-4 py-2 text-left">Status</th>
                    <th class="px-4 py-2 text-left">Requested At</th>
                    <th class="px-4 py-2 text-right">Action</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-slate-100">
                @forelse($requests as $req)
                    <tr class="hover:bg-slate-50">
                        <td class="px-4 py-2">
                            {{ $req->user->name ?? $req->user->email }}
                        </td>
                        <td class="px-4 py-2 font-medium">
                            {{ $req->client_name }}
                        </td>
                        <td class="px-4 py-2 text-xs text-gray-600">
                            {{ $req->notes ?: '—' }}
                        </td>
                        <td class="px-4 py-2">
                            <span class="inline-flex items-center rounded-full px-2 py-0.5 text-xs font-semibold
                                @if($req->status === 'pending') bg-amber-50 text-amber-700 border border-amber-200
                                @elseif($req->status === 'approved') bg-emerald-50 text-emerald-700 border border-emerald-200
                                @else bg-rose-50 text-rose-700 border border-rose-200
                                @endif">
                                {{ ucfirst($req->status) }}
                            </span>
                        </td>
                        <td class="px-4 py-2 text-xs text-gray-500">
                            {{ $req->created_at->format('d M Y H:i') }}
                        </td>
                        <td class="px-4 py-2 text-right">
                            <form method="POST" action="{{ route('admin.client-requests.updateStatus', $req) }}"
                                  class="inline-flex items-center gap-2">
                                @csrf
                                <select name="status"
                                        class="border border-slate-200 rounded-xl text-xs px-2 py-1">
                                    <option value="pending"  @selected($req->status === 'pending')>Pending</option>
                                    <option value="approved" @selected($req->status === 'approved')>Approved</option>
                                    <option value="rejected" @selected($req->status === 'rejected')>Rejected</option>
                                </select>
                                <button type="submit"
                                        class="px-3 py-1 rounded-xl bg-slate-800 text-white text-xs font-semibold hover:bg-slate-900">
                                    Update
                                </button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="px-4 py-6 text-center text-sm text-gray-500">
                            No client requests found.
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>

        <div class="px-4 py-3 border-t border-slate-100">
            {{ $requests->links() }}
        </div>
    </div>
@endsection
