@extends('layouts.admin')

@section('page-title', 'Create Client')
@section('page-subtitle', 'Add a client for conveyance tracking')

@section('content')

<div class="mb-6 flex flex-col md:flex-row md:items-center md:justify-between gap-3">
    <div>
        <h2 class="text-xl md:text-2xl font-extrabold tracking-tight">Create Client</h2>
        <p class="text-sm text-[color:var(--muted)] mt-1">
            Add a new client so employees can tag their conveyance correctly.
        </p>
    </div>
    <a href="{{ route('admin.clients.index') }}"
       class="inline-flex items-center gap-2 px-4 py-2.5 rounded-xl bg-[color:var(--bg-2)] border border-[color:var(--border)] text-sm font-semibold text-[color:var(--brand-dark)] hover:bg-slate-100 transition">
        <span class="text-base">←</span> Back to Clients
    </a>
</div>

<div class="max-w-xl rounded-3xl bg-[color:var(--surface)] border border-[color:var(--border)] shadow-sm p-6">
    <form method="POST" action="{{ route('admin.clients.store') }}" class="space-y-4">
        @csrf

        {{-- Name --}}
        <div>
            <label class="text-sm font-medium text-[color:var(--text)] block mb-1.5">
                Client Name
            </label>
            <input name="name"
                   value="{{ old('name') }}"
                   class="w-full border border-[color:var(--border)] rounded-xl px-3 py-2.5 text-sm
                          focus:outline-none focus:ring-2 focus:ring-[color:var(--brand)] focus:border-[color:var(--brand)]
                          placeholder:text-slate-400"
                   placeholder="e.g., ABC Technologies Pvt Ltd"
                   required>
        </div>

        {{-- Code + City --}}
        <div class="grid md:grid-cols-2 gap-4">
            <div>
                <label class="text-sm font-medium text-[color:var(--text)] block mb-1.5">
                    Client Code (optional)
                </label>
                <input name="code"
                       value="{{ old('code') }}"
                       class="w-full border border-[color:var(--border)] rounded-xl px-3 py-2.5 text-sm
                              focus:outline-none focus:ring-2 focus:ring-[color:var(--brand)] focus:border-[color:var(--brand)]
                              placeholder:text-slate-400"
                       placeholder="ABC-01">
            </div>

            <div>
                <label class="text-sm font-medium text-[color:var(--text)] block mb-1.5">
                    City / Location
                </label>
                <input name="city"
                       value="{{ old('city') }}"
                       class="w-full border border-[color:var(--border)] rounded-xl px-3 py-2.5 text-sm
                              focus:outline-none focus:ring-2 focus:ring-[color:var(--brand)] focus:border-[color:var(--brand)]
                              placeholder:text-slate-400"
                       placeholder="e.g., Bengaluru">
            </div>
        </div>

        {{-- Notes --}}
        <div>
            <label class="text-sm font-medium text-[color:var(--text)] block mb-1.5">
                Internal Notes (optional)
            </label>
            <textarea name="notes"
                      rows="3"
                      class="w-full border border-[color:var(--border)] rounded-xl px-3 py-2.5 text-sm
                             focus:outline-none focus:ring-2 focus:ring-[color:var(--brand)] focus:border-[color:var(--brand)]
                             placeholder:text-slate-400"
                      placeholder="Any internal information about this client...">{{ old('notes') }}</textarea>
        </div>

        {{-- Active toggle --}}
        <div class="flex items-center gap-2">
            <input id="is_active"
                   type="checkbox"
                   name="is_active"
                   value="1"
                   class="rounded border-[color:var(--border)] text-[color:var(--brand)] focus:ring-[color:var(--brand)]"
                   checked>
            <label for="is_active" class="text-sm text-[color:var(--text)]">
                Client is active (show in employee dropdown)
            </label>
        </div>

        <div class="pt-2">
            <button
                class="inline-flex items-center justify-center gap-2 px-5 py-2.5 rounded-xl
                       bg-[color:var(--brand)] text-white text-sm font-semibold
                       hover:bg-[color:var(--brand-dark)] transition shadow-sm">
                Save Client
            </button>
        </div>
    </form>
</div>

@endsection
