@extends('layouts.admin')

@section('page-title', 'Clients')
@section('page-subtitle', 'Master list of clients for conveyance tagging')

@section('content')

<div class="flex flex-col md:flex-row md:items-center md:justify-between gap-3 mb-5">
    <div>
        <h2 class="text-xl md:text-2xl font-extrabold tracking-tight">Clients</h2>
        <p class="text-sm text-[color:var(--muted)] mt-1">
            Manage the clients that employees can select while adding conveyance.
        </p>
    </div>

    <a href="{{ route('admin.clients.create') }}"
       class="inline-flex items-center gap-2 px-4 py-2.5 rounded-xl bg-[color:var(--brand)] text-white text-sm font-semibold hover:bg-[color:var(--brand-dark)] transition shadow-sm">
        + Create Client
    </a>
</div>

<div class="rounded-2xl bg-[color:var(--surface)] border border-[color:var(--border)] shadow-sm overflow-hidden">
    <div class="px-4 py-3 border-b border-[color:var(--border)] flex items-center justify-between">
        <div class="text-sm text-[color:var(--muted)]">
            Total clients: <span class="font-semibold text-[color:var(--text)]">{{ $clients->count() }}</span>
        </div>
    </div>

    <div class="overflow-x-auto">
        <table class="w-full text-sm">
            <thead class="bg-slate-50 text-[11px] uppercase tracking-wide text-[color:var(--muted)]">
                <tr>
                    <th class="p-3 text-left font-semibold">Name</th>
                    <th class="p-3 text-left font-semibold">Code</th>
                    <th class="p-3 text-left font-semibold">City</th>
                    <th class="p-3 text-center font-semibold">Status</th>
                    <th class="p-3 text-right font-semibold">Action</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-[color:var(--border)]">
                @forelse($clients as $client)
                    <tr class="hover:bg-slate-50/70 transition">
                        <td class="p-3 font-semibold text-[color:var(--text)]">
                            {{ $client->name }}
                        </td>
                        <td class="p-3 text-[color:var(--muted)]">
                            {{ $client->code ?? '—' }}
                        </td>
                        <td class="p-3 text-[color:var(--muted)]">
                            {{ $client->city ?? '—' }}
                        </td>
                        <td class="p-3 text-center">
                            @if($client->is_active)
                                <span class="inline-flex items-center gap-1 px-2.5 py-1 text-[11px] rounded-full bg-emerald-50 text-emerald-700 border border-emerald-200">
                                    <span class="h-1.5 w-1.5 rounded-full bg-emerald-500"></span>
                                    Active
                                </span>
                            @else
                                <span class="inline-flex items-center gap-1 px-2.5 py-1 text-[11px] rounded-full bg-slate-50 text-slate-600 border border-slate-200">
                                    Inactive
                                </span>
                            @endif
                        </td>
                        <td class="p-3 text-right">
                            <form method="POST" action="{{ route('admin.clients.toggle', $client) }}" class="inline">
                                @csrf
                                @method('PATCH')
                                <button
                                    class="inline-flex items-center gap-1 text-[11px] font-semibold text-[color:var(--brand-dark)] hover:text-[color:var(--brand)]">
                                    {{ $client->is_active ? 'Deactivate' : 'Activate' }}
                                </button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="p-4 text-center text-[13px] text-[color:var(--muted)]">
                            No clients created yet. Click “Create Client” to add one.
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>

@endsection
