@extends('layouts.admin_fullwidth')

@section('page-title', 'Employee Master – ' . ($currentMonthLabel ?? ''))
@section('page-subtitle', 'Month-wise consolidated conveyance for all employees')

@section('content')

@php
    use Carbon\Carbon;
    use Carbon\CarbonPeriod;

    $headerPeriod = CarbonPeriod::create($monthStart, $monthEnd);
    $today        = Carbon::today()->toDateString();
@endphp

<style>
    /* ===== GENERAL TABLE LOOK – EXCEL-LIKE ===== */
    table {
        font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
    }

    thead th,
    tbody td {
        border: 1px solid #d4d4d8; /* light grey border */
    }

    thead th {
        position: sticky;
        top: 0;
        z-index: 6;
        background-color: #f3f4f6; /* header grey like Excel */
        color: #111827;
        font-size: 11px;
        text-transform: uppercase;
        letter-spacing: 0.04em;
        padding-top: 6px;
        padding-bottom: 6px;
        box-shadow: 0 1px 0 rgba(17, 24, 39, 0.12);
    }

    tbody {
        background-color: #ffffff;
    }

    /* Row striping */
    tbody tr:nth-child(even) td:not(.freeze-col-1):not(.freeze-col-2) {
        background-color: #f9fafb;
    }

    /* Hover (subtle) */
    tbody tr:hover td:not(.freeze-col-1):not(.freeze-col-2) {
        background-color: #e5f3ff;
    }

    /* ===== FIXED / FROZEN COLUMNS (like Excel) ===== */
    .freeze-col-1 {
        position: sticky;
        left: 0;
        z-index: 8;
        background-color: #f3f4f6; /* light header-style grey */
        color: #111827;
        font-weight: 600;
    }

    .freeze-col-2 {
        position: sticky;
        left: 190px; /* width of Employee col */
        z-index: 8;
        background-color: #f3f4f6;
        color: #111827;
        font-weight: 600;
        text-align: center;
    }

    thead .freeze-col-1,
    thead .freeze-col-2 {
        z-index: 9;
        background-color: #e5e7eb; /* slightly deeper for header frozen cells */
    }

    /* Light vertical band every few columns (very subtle) */
    .col-band-light {
        background-color: #f5f5f5;
    }

    /* Sunday highlight – soft, like Excel weekend shading */
    .col-weekend {
        background-color: #fde2e2 !important;
        color: #92400e;
        font-weight: 600;
    }

    /* Today column – light blue outline */
    .col-today {
        background-color: #e0f2fe !important;
        box-shadow: inset 0 -2px 0 #2563eb;
        font-weight: 600;
    }

    /* Total row – footer style */
    .totals-row td {
        background-color: #e5e7eb;
        font-weight: 600;
    }

    /* Print helpers */
    .no-print {
        display: block;
    }

    @media print {
        body {
            background: #ffffff !important;
        }

        .no-print {
            display: none !important;
        }

        .print-full {
            border: none !important;
            box-shadow: none !important;
        }

        table {
            font-size: 11px;
        }
    }
</style>

<div class="w-full bg-white rounded-2xl border border-slate-200 shadow-sm p-4 space-y-3 print-full">
    <div class="h-1 rounded-t-2xl bg-gradient-to-r from-indigo-600 via-sky-500 to-emerald-400 shadow-md"></div>

    {{-- HEADER: LEFT (TITLE + VIEW + BUTTONS) | RIGHT (STATS) --}}
    <div class="no-print w-full">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
            <div class="flex-1">
                <div class="flex items-center gap-3">
                    <a href="{{ route('admin.dashboard') }}"
                       class="inline-flex items-center gap-3 px-4 py-2 rounded-full bg-gradient-to-r from-emerald-500 via-sky-500 to-indigo-600 text-white font-semibold shadow-xl hover:from-emerald-600 hover:via-sky-600 hover:to-indigo-700 focus:outline-none focus:ring-4 focus:ring-emerald-200/40 transition">
                        <svg class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7" />
                        </svg>
                        <span class="font-medium">Back to Admin</span>
                    </a>

                    <div>
                        <h1 class="text-lg md:text-2xl font-semibold text-slate-900 mx-auto text-center">Month-wise consolidated conveyance</h1>
                         
                    </div>
                </div>
            </div>

            <div class="flex items-center gap-3">
                <a href="{{ route('admin.conveyance.employeeMaster.export') . '?' . http_build_query(request()->query()) }}" 
                   class="inline-flex items-center gap-2 px-3 py-2 rounded-lg bg-gradient-to-r from-indigo-600 to-sky-500 text-white font-semibold hover:from-indigo-700 hover:to-sky-600 shadow-lg">
                    <svg class="w-4 h-4 text-white" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 5v14"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 12l-7 7-7-7"/></svg>
                    <span>Export</span>
                </a>

                <div class="ml-4 rounded-xl overflow-hidden shadow-md bg-gradient-to-br from-slate-900 to-indigo-700 text-white px-4 py-2 text-xs">
                    <div class="grid grid-cols-3 gap-3">
                        <div class="text-center">
                            <div class="text-[10px] uppercase opacity-80">Period</div>
                            <div class="font-semibold text-white">{{ $currentMonthLabel }}</div>
                        </div>
                        <div class="text-center">
                            <div class="text-[10px] uppercase opacity-80">Employees</div>
                            <div class="font-semibold text-white">{{ $employees->count() }}</div>
                        </div>
                        <div class="text-center">
                            <div class="text-[10px] uppercase opacity-80">Grand Total</div>
                            <div class="font-semibold text-emerald-300">₹ {{ number_format($grandTotal ?? 0, 2) }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- FILTERS – ONE ROW --}}
    <form method="GET" action="{{ route('admin.conveyance.employeeMaster') }}" class="no-print mt-4">
        <div class="bg-gradient-to-tr from-white to-slate-50 border border-indigo-50 rounded-lg p-3 shadow-lg">
            <div class="grid grid-cols-1 md:grid-cols-12 gap-3 items-end">
                <div class="md:col-span-3">
                    <label class="block text-[12px] font-semibold text-slate-700 mb-1">Month</label>
                    <select name="month" class="w-full border border-indigo-100 rounded-lg px-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-indigo-300">
                        <option value="">-- Select Month --</option>
                        @foreach ($months as $m)
                            <option value="{{ $m['value'] }}" @if(($filters['month'] ?? '') === $m['value']) selected @endif>
                                {{ $m['label'] }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="md:col-span-2">
                    <label class="block text-[12px] font-semibold text-slate-700 mb-1">From</label>
                    <input type="date" name="from_date" value="{{ $filters['from_date'] ?? '' }}" class="w-full border border-indigo-100 rounded-lg px-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-indigo-300">
                </div>

                <div class="md:col-span-2">
                    <label class="block text-[12px] font-semibold text-slate-700 mb-1">To</label>
                    <input type="date" name="to_date" value="{{ $filters['to_date'] ?? '' }}" class="w-full border border-indigo-100 rounded-lg px-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-indigo-300">
                </div>

                <div class="md:col-span-3">
                    <label class="block text-[12px] font-semibold text-slate-700 mb-1">Employee name</label>
                    <div class="relative">
                        <input type="text" name="name" value="{{ $filters['name'] ?? '' }}" placeholder="Search by employee name..." class="w-full border border-indigo-100 rounded-lg pl-10 pr-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-indigo-300">
                        <div class="absolute left-3 top-1/2 -translate-y-1/2 text-indigo-300">
                            <svg class="w-4 h-4" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-4.35-4.35"/><circle cx="11" cy="11" r="6" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"/></svg>
                        </div>
                    </div>
                </div>

                <div class="md:col-span-2 flex items-center md:justify-end gap-2">
                    <button type="submit" class="inline-flex items-center justify-center px-4 py-2 rounded-lg bg-gradient-to-r from-indigo-600 to-sky-500 text-white font-semibold hover:from-indigo-700 hover:to-sky-600 min-w-[88px] shadow">Apply</button>
                    <a href="{{ route('admin.conveyance.employeeMaster') }}" class="inline-flex items-center justify-center px-4 py-2 rounded-lg border border-indigo-100 bg-white text-sm text-indigo-700 hover:bg-indigo-50 min-w-[88px]">Reset</a>
                </div>
            </div>
        </div>
    </form>

    {{-- TABLE --}}
    <div class="border border-slate-200 rounded-xl overflow-hidden mt-1">
        <div class="max-h-[620px] overflow-y-auto overflow-x-auto bg-slate-50">
            <table class="border-collapse text-[13px] min-w-max w-full">

                {{-- HEADER --}}
                <thead>
                    <tr class="text-[11px]">
                        <th class="px-3 py-2 text-left w-48 freeze-col-1">
                            Employee
                        </th>

                        <th class="px-3 py-2 text-center w-24 freeze-col-2">
                            ₹
                        </th>

                        @php $dayIndex = 0; @endphp
                        @foreach ($headerPeriod as $date)
                            @php
                                $isSunday = $date->isSunday();
                                $isToday  = $date->toDateString() === $today;
                                $dayIndex++;
                                $band = ($dayIndex % 5 === 0);
                            @endphp

                            <th
                                class="px-2 py-2 text-center min-w-[52px]
                                       {{ $isSunday ? 'col-weekend' : '' }}
                                       {{ $isToday ? 'col-today' : '' }}
                                       {{ $band ? 'col-band-light' : '' }}"
                            >
                                <div class="font-semibold">
                                    {{ $date->format('d') }}
                                </div>
                                <div class="text-[10px] text-slate-400">
                                    {{ $date->format('D') }}
                                </div>
                            </th>
                        @endforeach
                    </tr>
                </thead>

                {{-- BODY --}}
                <tbody>
                    @foreach ($employees as $emp)
                        @php $rowPeriod = CarbonPeriod::create($monthStart, $monthEnd); @endphp

                        <tr class="border-b border-slate-200">
                            {{-- EMPLOYEE NAME --}}
                            <td class="px-3 py-2 font-semibold text-slate-900 freeze-col-1">
                                {{ $emp->name }}
                            </td>

                            {{-- EMPLOYEE TOTAL --}}
                            <td class="px-3 py-2 text-center font-bold text-emerald-800 freeze-col-2">
                                {{ number_format($totals[$emp->id] ?? 0, 2) }}
                            </td>

                            @php $dayIndex = 0; @endphp
                            @foreach ($rowPeriod as $day)
                                @php
                                    $dayStr   = $day->toDateString();
                                    $entry    = $data[$emp->id][$dayStr] ?? null;
                                    $isSunday = $day->isSunday();
                                    $isToday  = $dayStr === $today;
                                    $dayIndex++;
                                    $band = ($dayIndex % 5 === 0);
                                @endphp

                                <td
                                    class="px-1 py-2 text-center
                                           {{ $isSunday ? 'col-weekend' : '' }}
                                           {{ $isToday ? 'col-today' : '' }}
                                           {{ $band ? 'col-band-light' : '' }}"
                                >
                                    @if ($entry)
                                        <span class="text-[12px] font-semibold text-slate-900">
                                            {{ (int) $entry['amount'] }}
                                        </span>
                                        @if (!empty($entry['is_return']))
                                            <div class="text-[10px] text-rose-600 font-bold leading-tight">
                                                R*
                                            </div>
                                        @endif
                                    @else
                                        <span class="text-slate-300">—</span>
                                    @endif
                                </td>
                            @endforeach
                        </tr>
                    @endforeach

                    {{-- TOTAL ROW --}}
                    @php $footerPeriod = CarbonPeriod::create($monthStart, $monthEnd); @endphp
                    <tr class="totals-row text-[12px] text-slate-900 border-t border-slate-400">
                        <td class="px-3 py-2 freeze-col-1">
                            Total
                        </td>

                        <td class="px-3 py-2 text-center text-emerald-900 freeze-col-2">
                            {{ number_format($grandTotal ?? 0, 2) }}
                        </td>

                        @php $dayIndex = 0; @endphp
                        @foreach ($footerPeriod as $day)
                            @php
                                $dayStr    = $day->toDateString();
                                $colTotal  = $dayTotals[$dayStr] ?? 0;
                                $isSunday  = $day->isSunday();
                                $isToday   = $dayStr === $today;
                                $dayIndex++;
                                $band = ($dayIndex % 5 === 0);
                            @endphp

                            <td
                                class="px-1 py-2 text-center
                                       {{ $isSunday ? 'col-weekend' : '' }}
                                       {{ $isToday ? 'col-today' : '' }}
                                       {{ $band ? 'col-band-light' : '' }}"
                            >
                                @if ($colTotal > 0)
                                    <span class="text-[12px] font-semibold">
                                        {{ (int) $colTotal }}
                                    </span>
                                @else
                                    <span class="text-slate-300">—</span>
                                @endif
                            </td>
                        @endforeach
                    </tr>
                </tbody>

            </table>
        </div>
    </div>

</div>

@endsection
