@php
    use Carbon\CarbonPeriod;

    $period = CarbonPeriod::create($monthStart, $monthEnd);
@endphp
<table>
    <thead>
        <tr>
            <th colspan="{{ 2 + iterator_count($period) }}" style="font-weight:bold;font-size:14px;">
                Employee Master – {{ $currentMonthLabel }}
            </th>
        </tr>
        @php $period->rewind(); @endphp
        <tr>
            <th style="font-weight:bold;background:#e5e7eb;">Employee</th>
            <th style="font-weight:bold;background:#e5e7eb;">Total (₹)</th>
            @foreach ($period as $date)
                @php
                    $isSunday = $date->isSunday();
                    $bg = $isSunday ? '#fee2e2' : '#f3f4f6';
                @endphp
                <th style="font-weight:bold;background:{{ $bg }};">
                    {{ $date->format('d') }} ({{ $date->format('D') }})
                </th>
            @endforeach
        </tr>
    </thead>
    <tbody>
        @php $period->rewind(); @endphp
        @foreach ($employees as $emp)
            @php $rowPeriod = CarbonPeriod::create($monthStart, $monthEnd); @endphp
            <tr>
                <td>{{ $emp->name }}</td>
                <td>{{ number_format($totals[$emp->id] ?? 0, 2) }}</td>

                @foreach ($rowPeriod as $day)
                    @php
                        $dayStr = $day->toDateString();
                        $entry  = $data[$emp->id][$dayStr] ?? null;
                    @endphp
                    <td>
                        @if ($entry)
                            {{ (int) $entry['amount'] }}
                            @if (!empty($entry['is_return']))
                                (R*)
                            @endif
                        @endif
                    </td>
                @endforeach
            </tr>
        @endforeach

        {{-- Grand totals row --}}
        @php $footerPeriod = CarbonPeriod::create($monthStart, $monthEnd); @endphp
        <tr>
            <td style="font-weight:bold;">Total</td>
            <td style="font-weight:bold;">{{ number_format($grandTotal ?? 0, 2) }}</td>
            @foreach ($footerPeriod as $day)
                @php
                    $dayStr   = $day->toDateString();
                    $colTotal = $dayTotals[$dayStr] ?? 0;
                @endphp
                <td style="font-weight:bold;">
                    @if ($colTotal > 0)
                        {{ (int) $colTotal }}
                    @endif
                </td>
            @endforeach
        </tr>
    </tbody>
</table>
