@extends('layouts.admin_fullwidth')

@section('page-title', 'Employee Month Comparison')
@section('page-subtitle', 'Month-wise and day-wise conveyance for a single employee')

@section('content')

@php
    use Carbon\Carbon;
@endphp

<style>
    /* ===== GENERAL TABLE LOOK – EXCEL-LIKE ===== */
    table {
        font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
    }

    thead th,
    tbody td {
        border: 1px solid #d4d4d8; /* light grey border */
    }

    thead th {
        position: sticky;
        top: 0;
        z-index: 6;
        background-color: #f3f4f6; /* header grey like Excel */
        color: #111827;
        font-size: 11px;
        text-transform: uppercase;
        letter-spacing: 0.04em;
        padding-top: 6px;
        padding-bottom: 6px;
        box-shadow: 0 1px 0 rgba(17, 24, 39, 0.12);
    }

    tbody {
        background-color: #ffffff;
    }

    /* Row striping */
    tbody tr:nth-child(even) td:not(.freeze-col-1) {
        background-color: #f9fafb;
    }

    /* Hover (subtle) */
    tbody tr:hover td:not(.freeze-col-1) {
        background-color: #e5f3ff;
    }

    /* ===== FIXED / FROZEN FIRST COLUMN (Month) ===== */
    .freeze-col-1 {
        position: sticky;
        left: 0;
        z-index: 8;
        background-color: #f3f4f6; /* light header-style grey */
        color: #111827;
        font-weight: 600;
    }

    thead .freeze-col-1 {
        z-index: 9;
        background-color: #e5e7eb; /* slightly deeper for header frozen cells */
    }

    /* Light vertical band every few columns (very subtle) */
    .col-band-light {
        background-color: #f5f5f5;
    }

    /* Print helpers */
    .no-print {
        display: block;
    }

    @media print {
        body {
            background: #ffffff !important;
        }

        .no-print {
            display: none !important;
        }

        .print-full {
            border: none !important;
            box-shadow: none !important;
        }

        table {
            font-size: 11px;
        }
    }

    .hidden-row { display: none; }
</style>

<div class="w-full bg-white rounded-2xl border border-slate-200 shadow-sm p-4 space-y-3 print-full">
    {{-- TOP GRADIENT STRIP --}}
    <div class="h-1 rounded-t-2xl bg-gradient-to-r from-indigo-600 via-sky-500 to-emerald-400 shadow-md"></div>

     {{-- ========================================================= --}}
 {{-- ========================================================= --}}
{{-- ENTERPRISE HEADER (Clean, aligned, subtle, premium look) --}}
{{-- ========================================================= --}}
<div class="no-print w-full">

    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-6 pb-1">

        {{-- ================= LEFT SECTION ================= --}}
        <div class="flex items-start gap-4 flex-1">

            {{-- Back button --}}
            <a href="{{ route('admin.dashboard') }}"
               class="inline-flex items-center gap-2 px-3 py-1.5 rounded-lg
                      bg-slate-900 text-xs font-medium text-white shadow-sm
                      hover:bg-slate-800 transition">
                <svg class="w-4 h-4" viewBox="0 0 24 24" fill="none"
                     stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round"
                          d="M15 19l-7-7 7-7" />
                </svg>
                <span>Back</span>
            </a>

            {{-- Title + small meta --}}
            <div class="space-y-1">
                <h1 class="text-lg md:text-xl font-semibold text-slate-900">
                    Employee Month-wise Comparison
                </h1>
                <p class="text-[12px] text-slate-500">
                    Compare a single employee across multiple months with day-wise totals and detailed entries.
                </p>

                {{-- Selected meta line --}}
                <div class="flex flex-wrap items-center gap-3 text-[11px] text-slate-500 mt-2">

                    {{-- Employee --}}
                    <span class="inline-flex items-center gap-1">
                        <span class="uppercase tracking-wide text-[10px]">Employee:</span>
                        <span class="font-semibold text-slate-800">
                            {{ $selectedEmployee->name ?? 'Not selected' }}
                        </span>
                    </span>

                    <span class="w-px h-3 bg-slate-200"></span>

                    {{-- Months --}}
                    <span class="inline-flex items-center gap-1">
                        <span class="uppercase tracking-wide text-[10px]">Months:</span>

                        @if(!empty($monthsData))
                            <span class="inline-flex flex-wrap gap-1">
                                @foreach($monthsData as $m)
                                    <span class="px-1.5 py-0.5 rounded-full bg-slate-100 text-[10px] text-slate-700 border border-slate-200">
                                        {{ $m['label'] }}
                                    </span>
                                @endforeach
                            </span>
                        @else
                            <span class="font-semibold text-amber-600">None</span>
                        @endif
                    </span>

                </div>
            </div>
        </div>

        {{-- ================= RIGHT SECTION (Stats + Export) ================= --}}
        <div class="flex flex-col gap-2 md:w-[330px]">

            {{-- Stats Card --}}
            <div class="rounded-xl border border-slate-200 bg-white px-4 py-2.5 shadow-sm">
                <div class="grid grid-cols-3 gap-4 text-center">

                    <div>
                        <div class="text-[10px] uppercase text-slate-500 tracking-wide">Employee</div>
                        <div class="font-semibold text-slate-900 truncate">
                            {{ $selectedEmployee->name ?? '—' }}
                        </div>
                    </div>

                    <div>
                        <div class="text-[10px] uppercase text-slate-500 tracking-wide">Months</div>
                        <div class="font-semibold text-slate-900">
                            {{ !empty($monthsData) ? count($monthsData) : 0 }}
                        </div>
                    </div>

                    <div>
                        <div class="text-[10px] uppercase text-slate-500 tracking-wide">View</div>
                        <div class="font-semibold text-slate-900">
                            Summary + Details
                        </div>
                    </div>
                </div>
            </div>

            {{-- Export buttons --}}
            @if($selectedEmployee && !empty($monthsData))
                <div class="flex flex-wrap justify-end gap-2">

                    {{-- Summary --}}
                    <a href="{{ route('admin.conveyance.employeeMonthReport.exportSummary', request()->query()) }}"
                       class="inline-flex items-center gap-1.5 px-3 py-1.5
                              bg-indigo-600 hover:bg-indigo-700 text-white text-[11px]
                              rounded-lg shadow-sm transition">
                        <svg class="w-3.5 h-3.5 text-white" fill="none"
                             stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path d="M8 7h8m-8 4h4" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M5 5a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v14l-4-3-4 3-4-3-4 3V5z"
                                  stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                        Summary
                    </a>

                    {{-- Full --}}
                    <a href="{{ route('admin.conveyance.employeeMonthReport.exportFull', request()->query()) }}"
                       class="inline-flex items-center gap-1.5 px-3 py-1.5
                              bg-emerald-600 hover:bg-emerald-700 text-white text-[11px]
                              rounded-lg shadow-sm transition">
                        <svg class="w-3.5 h-3.5 text-white" fill="none"
                             stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path d="M12 5v14" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M19 12l-7 7-7-7" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                        Full Export
                    </a>

                </div>
            @endif

        </div>

    </div>
</div>



{{-- ========================================================= --}}
{{-- FILTERS SECTION – CLEAN ENTERPRISE LAYOUT + SELECT2 SEARCH --}}
{{-- ========================================================= --}}
<form method="GET"
      action="{{ route('admin.conveyance.employeeMonthReport') }}"
      class="no-print mt-4">

    <div class="rounded-2xl border border-slate-200 bg-white shadow-sm px-4 py-4">

        {{-- Title Row --}}
        <div class="flex items-center justify-between mb-4">
            <h2 class="text-xs font-semibold uppercase tracking-wide text-slate-700">Filters</h2>
        </div>

        {{-- GRID --}}
        <div class="grid grid-cols-1 md:grid-cols-12 gap-4">

            {{-- Employee (Select2 with search) --}}
            <div class="md:col-span-4">
                <label class="text-[12px] font-medium text-slate-700 mb-1 block">
                    Employee
                </label>

                <select name="employee_id"
                        id="employeeSelect"
                        class="w-full border border-slate-300 rounded-lg text-sm bg-white">
                    <option value="">-- Select Employee --</option>
                    @foreach($employees as $emp)
                        <option value="{{ $emp->id }}"
                            @if((int)$selectedEmployeeId === $emp->id) selected @endif>
                            {{ $emp->name }}
                        </option>
                    @endforeach
                </select>

                <p class="mt-1 text-[10px] text-slate-400">
                    Start typing to quickly find an employee from a large list.
                </p>
            </div>

            {{-- Comparison Period --}}
            <div class="md:col-span-6">
                <label class="text-[12px] font-medium text-slate-700 mb-1 block">
                    Comparison Period (Months)
                </label>

                <div class="flex flex-wrap gap-1.5 max-h-24 overflow-y-auto pr-1 border border-slate-300 rounded-lg p-2 bg-white">

                    @foreach($monthsOptions as $value => $label)
                        <label class="inline-flex items-center gap-1.5 px-2 py-1 rounded-full border text-[11px]
                                      cursor-pointer select-none
                                      @if(in_array($value, $selectedMonthsKeys))
                                          bg-indigo-50 border-indigo-300 text-indigo-800
                                      @else
                                          bg-slate-50 border-slate-200 text-slate-600 hover:bg-slate-100
                                      @endif">
                            <input type="checkbox"
                                   name="months[]"
                                   value="{{ $value }}"
                                   class="h-3 w-3 rounded border-slate-300 text-indigo-600 focus:ring-0"
                                   @if(in_array($value, $selectedMonthsKeys)) checked @endif>
                            <span>{{ $label }}</span>
                        </label>
                    @endforeach

                </div>
            </div>

            {{-- Buttons --}}
            <div class="md:col-span-2 flex items-end justify-end gap-2">
                <button type="submit"
                        class="px-4 py-2 rounded-lg bg-indigo-600 hover:bg-indigo-700 text-white text-sm font-semibold shadow-sm">
                    Apply
                </button>
                <a href="{{ route('admin.conveyance.employeeMonthReport') }}"
                   class="px-4 py-2 rounded-lg border border-slate-300 bg-white text-sm text-slate-700 hover:bg-slate-50">
                    Reset
                </a>
            </div>

        </div>
    </div>

</form>

{{-- ===================== --}}
{{-- Select2 (search inside dropdown) --}}
{{-- ===================== --}}

{{-- jQuery CDN (required for Select2) --}}
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

{{-- Select2 CSS & JS --}}
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

{{-- Small Select2 styling tweak to blend with Tailwind --}}
<style>
    .select2-container--default .select2-selection--single {
        border-radius: 0.5rem; /* rounded-lg */
        border: 1px solid #cbd5e1; /* slate-300 */
        height: 2.5rem; /* ~py-2 */
        display: flex;
        align-items: center;
    }
    .select2-container--default .select2-selection--single .select2-selection__rendered {
        padding-left: 0.75rem;
        font-size: 0.875rem; /* text-sm */
        color: #0f172a; /* slate-900 */
    }
    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: 100%;
        right: 0.5rem;
    }
    .select2-container .select2-dropdown {
        border-radius: 0.5rem;
        border-color: #cbd5e1;
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Initialize Select2 on employee select
        if (window.jQuery) {
            jQuery(function($) {
                $('#employeeSelect').select2({
                    placeholder: '-- Select Employee --',
                    allowClear: true,
                    width: '100%'
                });
            });
        }
    });
</script>


    {{-- INFO LINE BELOW FILTERS --}}
    @if($selectedEmployee && !empty($monthsData))
        <div class="no-print mt-1 text-[11px] text-slate-600 flex items-center justify-between">
            <span>
                Showing <span class="font-semibold">{{ count($monthsData) }}</span> month(s) for
                <span class="font-semibold">{{ $selectedEmployee->name }}</span>.
                Use ▸ to expand detailed day-wise entries.
            </span>
        </div>
    @elseif($selectedEmployeeId)
        <div class="no-print mt-1 text-[11px] text-amber-700 bg-amber-50 border border-amber-200 rounded-lg px-3 py-2">
            No submitted conveyance found for this employee in the selected months.
        </div>
    @endif

    {{-- SUMMARY GRID + DETAIL ROWS --}}
    @if($selectedEmployee && !empty($monthsData))
        <div class="border border-slate-200 rounded-xl overflow-hidden mt-2">
            <div class="max-h-[620px] overflow-y-auto overflow-x-auto bg-slate-50">
                <table class="border-collapse text-[13px] min-w-max w-full">
                   @php
    // Use the first selected month to calculate weekday labels in the header
    $firstMonth = $monthsData[0] ?? null;
@endphp

<thead>
    <tr class="text-[11px]">
        <th class="px-3 py-2 text-left w-48 freeze-col-1">
            Month
        </th>
        @for($d = 1; $d <= $maxDays; $d++)
            @php
                $band     = ($d % 5 === 0);
                $dayLabel = $d;
                $dowLabel = '';

                if ($firstMonth && $d <= $firstMonth['days_in_month']) {
                    /** @var \Carbon\Carbon $start */
                    $start   = $firstMonth['start'];
                    $date    = $start->copy()->day($d);
                    $dowLabel = $date->format('D'); // Sun, Mon, ...
                }
            @endphp
            <th class="px-2 py-2 text-center min-w-[40px] {{ $band ? 'col-band-light' : '' }}">
                <div class="font-semibold">
                    {{ $dayLabel }}
                </div>
                @if($dowLabel)
                    <div class="text-[10px] text-slate-400">
                        {{ $dowLabel }}
                    </div>
                @endif
            </th>
        @endfor
    </tr>
</thead>

                    <tbody>
                        @foreach($monthsData as $mIndex => $month)
                            @php
                                /** @var \Carbon\Carbon $start */
                                $start = $month['start'];
                                $daysInMonth = $month['days_in_month'];
                            @endphp

                            {{-- SUMMARY ROW --}}
                            <tr class="border-b border-slate-200 bg-white hover:bg-slate-50">
                                {{-- Month label + expand button --}}
                                <td class="px-3 py-2 border border-slate-200 text-left align-top freeze-col-1">
                                    <div class="flex items-center gap-2">
                                        <button type="button"
                                                class="text-xs rounded-full border border-slate-300 px-1.5 py-0.5 hover:bg-slate-100 toggle-details"
                                                data-target="details-{{ $month['key'] }}">
                                            ▸
                                        </button>
                                        <div>
                                            <div class="text-[12px] font-semibold text-slate-900">
                                                {{ $month['label'] }}
                                            </div>
                                            <div class="text-[10px] text-slate-400">
                                                {{ $start->format('d M') }} – {{ $month['end']->format('d M Y') }}
                                            </div>
                                        </div>
                                    </div>
                                </td>

                                {{-- Day cells --}}
                                @for($d = 1; $d <= $maxDays; $d++)
                                    @php
                                        if ($d > $daysInMonth) {
                                            $info = null;
                                        } else {
                                            $date = $start->copy()->day($d);
                                            $dateKey = $date->toDateString();
                                            $info = $month['daily'][$dateKey] ?? null;
                                        }
                                        $band = ($d % 5 === 0);
                                    @endphp
                                    <td class="px-1.5 py-1.5 border border-slate-200 text-center align-middle {{ $band ? 'col-band-light' : '' }}">
                                        @if($info)
                                            <div class="text-[11px] font-semibold text-slate-900">
                                                {{ (int) $info['total'] }}
                                                @if($info['return_diff'])
                                                    <span class="text-[9px] text-rose-600 font-bold">R*</span>
                                                @endif
                                            </div>
                                        @else
                                            <span class="text-slate-300 text-[11px]">—</span>
                                        @endif
                                    </td>
                                @endfor
                            </tr>

                            {{-- DETAIL ROW FOR THIS MONTH --}}
                            <tr id="details-{{ $month['key'] }}" class="hidden-row bg-white">
                                <td colspan="{{ $maxDays + 1 }}" class="border border-slate-200 px-3 py-3">
                                    @if($month['rows']->isEmpty())
                                        <p class="text-[11px] text-slate-500">
                                            No conveyance entries for {{ $month['label'] }}.
                                        </p>
                                    @else
                                        <div class="text-[11px] text-slate-500 mb-2">
                                            Detailed day-wise entries for <span class="font-semibold">{{ $month['label'] }}</span>
                                        </div>
                                        <div class="overflow-x-auto">
                                            <table class="min-w-full text-[11px] border border-slate-200">
                                                <thead class="bg-slate-100">
                                                    <tr>
                                                        <th class="px-2 py-1 border border-slate-200 text-left">Date</th>
                                                        <th class="px-2 py-1 border border-slate-200 text-left">Day</th>
                                                        <th class="px-2 py-1 border border-slate-200 text-left">From</th>
                                                        <th class="px-2 py-1 border border-slate-200 text-left">To</th>
                                                        <th class="px-2 py-1 border border-slate-200 text-left">Client</th>
                                                        <th class="px-2 py-1 border border-slate-200 text-left">Mode</th>
                                                        <th class="px-2 py-1 border border-slate-200 text-right">Onward</th>
                                                        <th class="px-2 py-1 border border-slate-200 text-right">Return</th>
                                                        <th class="px-2 py-1 border border-slate-200 text-right">Total</th>
                                                        <th class="px-2 py-1 border border-slate-200 text-left">Remarks</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($month['rows'] as $row)
                                                        @php
                                                            $onward = (float)$row->amount;
                                                            $return = 0.0;
                                                            if ($row->is_return) {
                                                                $return = $row->return_amount !== null
                                                                    ? (float)$row->return_amount
                                                                    : $onward;
                                                            }
                                                            $total = $onward + $return;
                                                        @endphp
                                                        <tr class="hover:bg-slate-50">
                                                            <td class="px-2 py-1 border border-slate-200">
                                                                {{ $row->date->format('d M Y') }}
                                                            </td>
                                                            <td class="px-2 py-1 border border-slate-200">
                                                                {{ $row->date->format('D') }}
                                                            </td>
                                                            <td class="px-2 py-1 border border-slate-200">
                                                                {{ $row->from_location }}
                                                            </td>
                                                            <td class="px-2 py-1 border border-slate-200">
                                                                {{ $row->to_location }}
                                                            </td>
                                                            <td class="px-2 py-1 border border-slate-200">
                                                                {{ optional($row->client)->name ?? '—' }}
                                                            </td>
                                                            <td class="px-2 py-1 border border-slate-200">
                                                                {{ $row->mode ?? '—' }}
                                                            </td>
                                                            <td class="px-2 py-1 border border-slate-200 text-right">
                                                                {{ number_format($onward, 2) }}
                                                            </td>
                                                            <td class="px-2 py-1 border border-slate-200 text-right">
                                                                @if($row->is_return)
                                                                    {{ number_format($return, 2) }}
                                                                    @if($row->return_amount !== null && (float)$row->return_amount !== $onward)
                                                                        <span class="text-[9px] text-rose-600 font-bold">R*</span>
                                                                    @endif
                                                                @else
                                                                    —
                                                                @endif
                                                            </td>
                                                            <td class="px-2 py-1 border border-slate-200 text-right font-semibold">
                                                                {{ number_format($total, 2) }}
                                                            </td>
                                                            <td class="px-2 py-1 border border-slate-200">
                                                                {{ $row->remarks ?? '—' }}
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @endif

</div>

{{-- SIMPLE JS FOR EXPAND/COLLAPSE --}}
<script>
    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('.toggle-details').forEach(function (btn) {
            btn.addEventListener('click', function () {
                var targetId = btn.getAttribute('data-target');
                var row = document.getElementById(targetId);
                if (!row) return;

                if (row.classList.contains('hidden-row')) {
                    row.classList.remove('hidden-row');
                    btn.textContent = '▾';
                } else {
                    row.classList.add('hidden-row');
                    btn.textContent = '▸';
                }
            });
        });
    });
</script>

@endsection
