{{-- resources/views/admin/conveyance/exports/employee_month_full.blade.php --}}
{{-- This view is for ONE month, used as ONE sheet by EmployeeConveyanceMonthFullExport --}}

<table>
    <tr>
        <th colspan="10">
            Employee Conveyance – {{ $employee->name }} – {{ $month['label'] }}
        </th>
    </tr>
    <tr></tr>
    <tr>
        <th>Date</th>
        <th>Day</th>
        <th>From</th>
        <th>To</th>
        <th>Client</th>
        <th>Mode</th>
        <th>Onward</th>
        <th>Return</th>
        <th>Total</th>
        <th>Remarks</th>
    </tr>

    @foreach($month['rows'] as $row)
        @php
            $onward = (float) $row->amount;
            $return = 0.0;

            if ($row->is_return) {
                $return = $row->return_amount !== null
                    ? (float) $row->return_amount
                    : $onward;
            }

            $total = $onward + $return;
        @endphp
        <tr>
            <td>{{ $row->date->format('d M Y') }}</td>
            <td>{{ $row->date->format('D') }}</td>
            <td>{{ $row->from_location }}</td>
            <td>{{ $row->to_location }}</td>
            <td>{{ optional($row->client)->name }}</td>
            <td>{{ $row->mode }}</td>
            <td>{{ $onward }}</td>
            <td>
                @if($row->is_return)
                    {{ $return }}
                    @if($row->return_amount !== null && (float)$row->return_amount !== $onward)
                        R*
                    @endif
                @endif
            </td>
            <td>{{ $total }}</td>
            <td>{{ $row->remarks }}</td>
        </tr>
    @endforeach
</table>
