{{-- resources/views/admin/conveyance/exports/employee_month_summary.blade.php --}}

<table>
    <tr>
        <th colspan="{{ $maxDays + 1 }}">
            Employee Conveyance – Month Summary ({{ $employee->name }})
        </th>
    </tr>
    <tr></tr>

    @php
        // Use the first selected month to calculate weekday labels in the header,
        // same logic as UI grid.
        $firstMonth = $monthsData[0] ?? null;
    @endphp

    {{-- HEADER ROW: Month | 1 (Sun) | 2 (Mon) | ... --}}
    <tr>
        <th>Month</th>
        @for($d = 1; $d <= $maxDays; $d++)
            @php
                $dayLabel = $d;
                $dowLabel = '';

                if ($firstMonth && $d <= $firstMonth['days_in_month']) {
                    /** @var \Carbon\Carbon $start */
                    $start   = $firstMonth['start'];
                    $date    = $start->copy()->day($d);
                    $dowLabel = $date->format('D'); // Sun, Mon, Tue...
                }
            @endphp
            <th>
                {{ $dayLabel }}
                @if($dowLabel)
                    ({{ $dowLabel }})
                @endif
            </th>
        @endfor
    </tr>

    {{-- DATA ROWS PER MONTH --}}
    @foreach($monthsData as $month)
        @php
            /** @var \Carbon\Carbon $start */
            $start       = $month['start'];
            $daysInMonth = $month['days_in_month'];
        @endphp

        <tr>
            {{-- Month name --}}
            <td>{{ $month['label'] }}</td>

            {{-- Day cells --}}
            @for($d = 1; $d <= $maxDays; $d++)
                @php
                    if ($d > $daysInMonth) {
                        $info = null;
                    } else {
                        $date    = $start->copy()->day($d);
                        $dateKey = $date->toDateString();
                        $info    = $month['daily'][$dateKey] ?? null;
                    }
                @endphp

                <td>
                    @if($info)
                        {{ (int) $info['total'] }}
                        @if($info['return_diff'])
                            R*
                        @endif
                    @endif
                </td>
            @endfor
        </tr>
    @endforeach
</table>
