@extends('layouts.admin')

@section('page-title', 'Client Conveyance')
@section('page-subtitle', 'Primary dashboard for month-wise client conveyance')

@section('content')
    @php
        $activeSession = \App\Models\Session::active();
        $totalClients = $clientSummaries->count();
        $totalAmount = $clientSummaries->sum('total_amount');
        $totalEmpMapped = $clientSummaries->sum('employee_count');
    @endphp

    {{-- WRAPPER --}}
    <div class="-mx-4 -mt-4 px-4 pb-6 md:px-6 md:pb-8 lg:px-8 bg-slate-50 min-h-screen">

        {{-- 1. TOP STATS ROW (VIBRANT & COMPACT) --}}
        <div class="grid grid-cols-2 lg:grid-cols-4 gap-4 mb-6 pt-4">

            {{-- Stat 1 --}}
            <div class="bg-white rounded-2xl p-4 border border-slate-100 shadow-sm flex items-center justify-between">
                <div>
                    <p class="text-[10px] uppercase font-bold text-slate-400 tracking-wider">Total Claims</p>
                    <p class="text-xl font-extrabold text-slate-800 mt-1">₹
                        {{ number_format($totalConveyanceThisMonth, 0) }}</p>
                    <p
                        class="text-[10px] text-emerald-600 font-medium bg-emerald-50 px-1.5 py-0.5 rounded-md inline-block mt-1">
                        {{ $currentMonthLabel }}
                    </p>
                </div>
                <div class="w-10 h-10 rounded-full bg-blue-50 text-blue-600 flex items-center justify-center">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z">
                        </path>
                    </svg>
                </div>
            </div>

            {{-- Stat 2 --}}
            <div class="bg-white rounded-2xl p-4 border border-slate-100 shadow-sm flex items-center justify-between">
                <div>
                    <p class="text-[10px] uppercase font-bold text-slate-400 tracking-wider">Active Clients</p>
                    <p class="text-xl font-extrabold text-slate-800 mt-1">{{ $clientsThisMonth }}</p>
                    <p class="text-[10px] text-slate-400 font-medium mt-1">in current month</p>
                </div>
                <div class="w-10 h-10 rounded-full bg-violet-50 text-violet-600 flex items-center justify-center">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4">
                        </path>
                    </svg>
                </div>
            </div>

            {{-- Stat 3 (Employees) --}}
            <div class="bg-white rounded-2xl p-4 border border-slate-100 shadow-sm flex items-center justify-between">
                <div>
                    <p class="text-[10px] uppercase font-bold text-slate-400 tracking-wider">Employees</p>
                    <p class="text-xl font-extrabold text-slate-800 mt-1">{{ $totalEmployees }}</p>
                    <p class="text-[10px] text-slate-400 font-medium mt-1">Total Registered</p>
                </div>
                <div class="w-10 h-10 rounded-full bg-amber-50 text-amber-600 flex items-center justify-center">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z">
                        </path>
                    </svg>
                </div>
            </div>

            {{-- Stat 4 (Session) --}}
            <div
                class="bg-gradient-to-br from-indigo-500 to-purple-600 rounded-2xl p-4 shadow-md flex items-center justify-between text-white">
                <div>
                    <p class="text-[10px] uppercase font-bold text-indigo-100 tracking-wider">Active Session</p>
                    <p class="text-lg font-bold mt-1 text-white truncate max-w-[140px]"
                        title="{{ $activeSession->name ?? 'None' }}">
                        {{ $activeSession->name ?? 'None' }}
                    </p>
                    <p class="text-[10px] text-indigo-100 font-medium mt-1">Current Fiscal</p>
                </div>
                <div class="w-10 h-10 rounded-full bg-white/20 flex items-center justify-center backdrop-blur-sm">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z">
                        </path>
                    </svg>
                </div>
            </div>
        </div>

        {{-- 2. CHART & INSIGHTS GRID (COMPACT) --}}
        {{-- 2. INSIGHTS GRID (MONTHLY & ALL TIME) --}}
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">

            {{-- 1. Top Employees (This Month) --}}
            <div class="bg-white rounded-2xl border border-slate-200 shadow-sm overflow-hidden">
                <div class="bg-indigo-50/50 px-4 py-3 border-b border-indigo-100 flex justify-between items-center">
                    <h3 class="text-xs font-bold text-indigo-900 uppercase tracking-wide">🏆 Users <span class="text-[9px] text-indigo-400 normal-case ml-1">(Month)</span></h3>
                </div>
                <div class="divide-y divide-slate-50">
                    @forelse($topEmployeesMonth as $index => $emp)
                    <div class="px-4 py-2.5 flex items-center justify-between hover:bg-slate-50 transition">
                        <div class="flex items-center gap-2">
                            <span class="text-[10px] font-bold text-slate-400 w-3">{{ $index + 1 }}</span>
                            <div class="truncate max-w-[80px]">
                                <div class="text-[11px] font-semibold text-slate-700 truncate" title="{{ $emp->user->name ?? '-' }}">
                                    {{ $emp->user->name ?? '-' }}
                                </div>
                            </div>
                        </div>
                        <div class="text-[11px] font-bold text-indigo-600">₹{{ number_format($emp->total_payout/1000, 1) }}k</div>
                    </div>
                    @empty
                        <div class="p-4 text-center text-[10px] text-slate-400 italic">No data</div>
                    @endforelse
                </div>
            </div>

            {{-- 2. Top Clients (This Month) --}}
            <div class="bg-white rounded-2xl border border-slate-200 shadow-sm overflow-hidden">
                <div class="bg-indigo-50/50 px-4 py-3 border-b border-indigo-100 flex justify-between items-center">
                    <h3 class="text-xs font-bold text-indigo-900 uppercase tracking-wide">🏢 Clients <span class="text-[9px] text-indigo-400 normal-case ml-1">(Month)</span></h3>
                </div>
                <div class="divide-y divide-slate-50">
                    @forelse($topClientsMonth as $index => $cli)
                    <div class="px-4 py-2.5 flex items-center justify-between hover:bg-slate-50 transition">
                        <div class="flex items-center gap-2">
                            <span class="text-[10px] font-bold text-slate-400 w-3">{{ $index + 1 }}</span>
                            <div class="truncate max-w-[80px]">
                                <div class="text-[11px] font-semibold text-slate-700 truncate" title="{{ $cli->client->name ?? '-' }}">
                                    {{ $cli->client->name ?? '-' }}
                                </div>
                            </div>
                        </div>
                        <div class="text-[11px] font-bold text-emerald-600">₹{{ number_format($cli->total_payout/1000, 1) }}k</div>
                    </div>
                    @empty
                        <div class="p-4 text-center text-[10px] text-slate-400 italic">No data</div>
                    @endforelse
                </div>
            </div>

            {{-- 3. Top Employees (All Time) --}}
            <div class="bg-white rounded-2xl border border-slate-200 shadow-sm overflow-hidden">
                <div class="bg-slate-50 px-4 py-3 border-b border-slate-100 flex justify-between items-center">
                    <h3 class="text-xs font-bold text-slate-700 uppercase tracking-wide">🏆 Users <span class="text-[9px] text-slate-400 normal-case ml-1">(All)</span></h3>
                </div>
                <div class="divide-y divide-slate-50">
                    @foreach($topEmployees->take(5) as $index => $emp)
                    <div class="px-4 py-2.5 flex items-center justify-between hover:bg-slate-50 transition">
                        <div class="flex items-center gap-2">
                            <span class="text-[10px] font-bold text-slate-400 w-3">{{ $index + 1 }}</span>
                            <div class="truncate max-w-[80px]">
                                <div class="text-[11px] font-semibold text-slate-700 truncate" title="{{ $emp->user->name }}">
                                    {{ $emp->user->name }}
                                </div>
                            </div>
                        </div>
                        <div class="text-[11px] font-bold text-indigo-600">₹{{ number_format($emp->total_payout/1000, 1) }}k</div>
                    </div>
                    @endforeach
                    @if($topEmployees->isEmpty())
                        <div class="p-4 text-center text-xs text-slate-400 italic">No data</div>
                    @endif
                </div>
            </div>

            {{-- 4. Top Clients (All Time) --}}
            <div class="bg-white rounded-2xl border border-slate-200 shadow-sm overflow-hidden">
                <div class="bg-slate-50 px-4 py-3 border-b border-slate-100 flex justify-between items-center">
                    <h3 class="text-xs font-bold text-slate-700 uppercase tracking-wide">🏢 Clients <span class="text-[9px] text-slate-400 normal-case ml-1">(All)</span></h3>
                </div>
                <div class="divide-y divide-slate-50">
                    @foreach($topClients->take(5) as $index => $cli)
                    <div class="px-4 py-2.5 flex items-center justify-between hover:bg-slate-50 transition">
                        <div class="flex items-center gap-2">
                             <span class="text-[10px] font-bold text-slate-400 w-3">{{ $index + 1 }}</span>
                            <div class="truncate max-w-[80px]">
                                <div class="text-[11px] font-semibold text-slate-700 truncate" title="{{ $cli->client->name }}">
                                    {{ $cli->client->name }}
                                </div>
                            </div>
                        </div>
                        <div class="text-[11px] font-bold text-emerald-600">₹{{ number_format($cli->total_payout/1000, 1) }}k</div>
                    </div>
                    @endforeach
                    @if($topClients->isEmpty())
                        <div class="p-4 text-center text-xs text-slate-400 italic">No data</div>
                    @endif
                </div>
            </div>

        </div>

        {{-- 3. CLIENT CARDS GRID (COMPACT) --}}
        <div class="mb-2 flex items-center justify-between">
            <h3 class="text-sm font-bold text-slate-700">Client Summaries ({{ $currentMonthLabel }})</h3>
        </div>

        @php
            // Softer gradients for compact feel
            $cardStyles = [
                ['bg' => 'bg-white border-l-4 border-l-cyan-500', 'text' => 'text-cyan-600'],
                ['bg' => 'bg-white border-l-4 border-l-violet-500', 'text' => 'text-violet-600'],
                ['bg' => 'bg-white border-l-4 border-l-pink-500', 'text' => 'text-pink-600'],
                ['bg' => 'bg-white border-l-4 border-l-emerald-500', 'text' => 'text-emerald-600'],
                ['bg' => 'bg-white border-l-4 border-l-amber-500', 'text' => 'text-amber-600'],
            ];
        @endphp

        @if ($clientSummaries->isEmpty())
            <div class="rounded-xl bg-white border border-dashed border-slate-300 p-6 text-center">
                <p class="text-xs text-slate-500">No client conveyance recorded for this month.</p>
            </div>
        @else
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4">
                @foreach ($clientSummaries->sortByDesc('total_amount') as $index => $cs)
                    @php $style = $cardStyles[$index % count($cardStyles)]; @endphp

                    <a href="{{ route('admin.conveyance.clientEmployees', array_merge(['client' => $cs['client_id'] ?? null], request()->query())) }}"
                        class="relative group rounded-xl p-4 shadow-sm border border-slate-100 hover:shadow-md transition-all {{ $style['bg'] }}">

                        <div class="flex justify-between items-start mb-2">
                            <div class="truncate pr-2">
                                <h4 class="text-[13px] font-bold text-slate-800 truncate" title="{{ $cs['name'] }}">
                                    {{ $cs['name'] ?? 'Unnamed' }}
                                </h4>
                                <p class="text-[10px] text-slate-400 truncate">{{ $cs['city'] ?? 'No City' }}</p>
                            </div>
                            <div class="{{ $style['text'] }}">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                                </svg>
                            </div>
                        </div>

                        <div class="flex items-end justify-between mt-3">
                            <div>
                                <p class="text-[10px] text-slate-400 font-medium">Total</p>
                                <p class="text-lg font-extrabold text-slate-800 leading-tight">
                                    ₹{{ number_format($cs['total_amount'], 0) }}
                                </p>
                            </div>
                            <div class="text-right">
                                <span
                                    class="text-[10px] bg-slate-100 text-slate-500 px-1.5 py-0.5 rounded font-medium group-hover:bg-slate-200 transition">
                                    View ↗
                                </span>
                            </div>
                        </div>
                    </a>
                @endforeach
            </div>
        @endif
    </div>
@endsection