@extends('layouts.admin')

@section('page-title', 'Add Employee')
@section('page-subtitle', 'Create employee & link to a financial session')

@section('content')

<div class="mb-6 flex flex-col md:flex-row md:items-center md:justify-between gap-3">
    <div>
        <h2 class="text-xl md:text-2xl font-extrabold tracking-tight">Add Employee</h2>
        <p class="text-sm text-[color:var(--muted)] mt-1">
            Create a new employee and assign them to the correct financial session.
        </p>
    </div>
    <a href="{{ route('admin.employees.index') }}"
       class="inline-flex items-center gap-2 px-4 py-2.5 rounded-xl bg-[color:var(--bg-2)] border border-[color:var(--border)] text-sm font-semibold text-[color:var(--brand-dark)] hover:bg-slate-100 transition">
        <span class="text-base">←</span> Back to Employees
    </a>
</div>

<div class="grid lg:grid-cols-3 gap-5">

    {{-- Form --}}
    <div class="lg:col-span-2 rounded-3xl bg-[color:var(--surface)] border border-[color:var(--border)] shadow-sm p-6">
        <div class="mb-4">
            <h3 class="text-lg font-semibold">Employee details</h3>
            <p class="text-xs text-[color:var(--muted)] mt-1">
                Basic profile and session assignment. All fields are mandatory.
            </p>
        </div>

        <form method="POST"
              action="{{ route('admin.employees.store') }}"
              class="grid md:grid-cols-2 gap-4">
            @csrf

           

            {{-- Name --}}
            <div>
                <label class="text-sm font-medium text-[color:var(--text)] block mb-1.5">
                    Full Name
                </label>
                <input name="name"
                       value="{{ old('name') }}"
                       class="w-full border border-[color:var(--border)] rounded-xl px-3 py-2.5 text-sm
                              focus:outline-none focus:ring-2 focus:ring-[color:var(--brand)] focus:border-[color:var(--brand)]
                              placeholder:text-slate-400"
                       placeholder="Employee name"
                       required>
            </div>

            {{-- Email --}}
            <div>
                <label class="text-sm font-medium text-[color:var(--text)] block mb-1.5">
                    Email
                </label>
                <input name="email"
                       type="email"
                       value="{{ old('email') }}"
                       class="w-full border border-[color:var(--border)] rounded-xl px-3 py-2.5 text-sm
                              focus:outline-none focus:ring-2 focus:ring-[color:var(--brand)] focus:border-[color:var(--brand)]
                              placeholder:text-slate-400"
                       placeholder="name@company.com"
                       required>
            </div>

            {{-- Phone --}}
            <div>
                <label class="text-sm font-medium text-[color:var(--text)] block mb-1.5">
                    Phone
                </label>
                <input name="phone"
                       value="{{ old('phone') }}"
                       class="w-full border border-[color:var(--border)] rounded-xl px-3 py-2.5 text-sm
                              focus:outline-none focus:ring-2 focus:ring-[color:var(--brand)] focus:border-[color:var(--brand)]
                              placeholder:text-slate-400"
                       placeholder="+91-XXXX-XXXXXX"
                       required>
            </div>

            {{-- Session --}}
            <div >
                <label class="text-sm font-medium text-[color:var(--text)] block mb-1.5">
                    Assign to Financial Session
                </label>
                <select name="session_id"
                        class="w-full border border-[color:var(--border)] rounded-xl px-3 py-2.5 text-sm
                               focus:outline-none focus:ring-2 focus:ring-[color:var(--brand)] focus:border-[color:var(--brand)]
                               bg-white"
                        required>
                    @foreach($sessions as $s)
                        <option value="{{ $s->id }}" {{ old('session_id') == $s->id ? 'selected' : '' }}>
                            {{ $s->name }} {{ $s->is_active ? '(Active)' : '' }}
                        </option>
                    @endforeach
                </select>
                <p class="text-[11px] text-[color:var(--muted)] mt-1">
                    Employee can later be attached to additional sessions from the Employees list.
                </p>
            </div>

            <div class="md:col-span-2 pt-2">
                <button
                    class="w-full md:w-auto inline-flex items-center justify-center gap-2 px-5 py-2.5 rounded-xl
                           bg-[color:var(--brand)] text-white text-sm font-semibold
                           hover:bg-[color:var(--brand-dark)] transition shadow-sm">
                    Save Employee
                </button>
            </div>
        </form>
    </div>

    {{-- Side info card --}}
    <div class="rounded-3xl bg-[color:var(--surface)] border border-[color:var(--border)] shadow-sm p-5">
        <h4 class="text-sm font-semibold mb-2">How this works</h4>
        <ul class="text-xs text-[color:var(--muted)] space-y-1.5">
            <li>• Each employee has one <span class="font-semibold text-[color:var(--text)]">master profile</span>.</li>
            <li>• You assign them to at least one <span class="font-semibold text-[color:var(--text)]">financial session</span>.</li>
            <li>• Later, you can attach the same employee to multiple sessions from the listing page.</li>
        </ul>

        <div class="mt-4 p-3 rounded-2xl bg-[color:var(--bg-2)] text-[11px] text-[color:var(--muted)] border border-[color:var(--border)]">
            <div class="font-semibold text-[color:var(--text)] mb-1">Best practice</div>
            Keep employee codes consistent (e.g., EMP-001, EMP-002…) so reporting is clean and easy.
        </div>
    </div>
</div>

@endsection
