@extends('layouts.admin')

@section('page-title', 'Edit Employee')
@section('page-subtitle', 'Update employee details and status')

@section('content')
    @if ($errors->any())
        <div class="mb-4 rounded border border-red-200 bg-red-50 px-3 py-2 text-sm text-red-700">
            <ul class="list-disc pl-4">
                @foreach ($errors->all() as $error)
                    <li class="text-xs">{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="mb-4 flex items-center justify-between">
        <h2 class="text-lg font-semibold text-gray-900">Edit Employee</h2>
        <a href="{{ route('admin.employees.index') }}" class="text-xs text-gray-600 hover:text-gray-800">
            ← Back to list
        </a>
    </div>

    <form action="{{ route('admin.employees.update', $employee) }}" method="POST" class="space-y-4 max-w-lg">
        @csrf
        @method('PUT')

        <div>
            <label class="block text-xs font-semibold mb-1 text-gray-700">Name</label>
            <input type="text" name="name" value="{{ old('name', $employee->name) }}"
                   class="w-full border rounded px-2 py-1.5 text-sm">
        </div>

        <div>
            <label class="block text-xs font-semibold mb-1 text-gray-700">Email</label>
            <input type="email" name="email" value="{{ old('email', $employee->email) }}"
                   class="w-full border rounded px-2 py-1.5 text-sm">
        </div>

        <div>
            <label class="block text-xs font-semibold mb-1 text-gray-700">Phone</label>
            <input type="text" name="phone" value="{{ old('phone', $employee->phone) }}"
                   class="w-full border rounded px-2 py-1.5 text-sm">
        </div>

        <div class="flex items-center gap-2">
            <input type="checkbox" name="is_active" id="is_active"
                   value="1" @checked(old('is_active', $employee->is_active))>
            <label for="is_active" class="text-xs text-gray-700">Employee is Active (can login using OTP)</label>
        </div>

        {{-- Optional: session multi-select (if you want to edit sessions here) --}}
        <div>
            <label class="block text-xs font-semibold mb-1 text-gray-700">Sessions (optional)</label>
            <select name="session_ids[]" multiple
                    class="w-full border rounded px-2 py-1.5 text-xs h-28">
                @foreach($sessions as $s)
                    <option value="{{ $s->id }}"
                        @selected(in_array($s->id, old('session_ids', $employeeSessionIds)))>
                        {{ $s->name }}
                    </option>
                @endforeach
            </select>
            <p class="mt-1 text-[11px] text-gray-500">
                Hold Ctrl (Windows) or Cmd (Mac) to select multiple sessions.
            </p>
        </div>

        <button type="submit"
                class="inline-flex items-center rounded-md bg-gray-900 px-3 py-1.5 text-xs font-semibold text-white hover:bg-gray-800">
            Save Changes
        </button>
    </form>
@endsection
