@extends('layouts.admin')

@section('page-title', 'Employees')
@section('page-subtitle', 'Session-wise employee master & status control')

@section('content')
    {{-- Flash message --}}
    @if(session('success'))
        <div class="mb-4 rounded border border-green-200 bg-green-50 px-3 py-2 text-sm text-green-800">
            {{ session('success') }}
        </div>
    @endif

    {{-- Header row: title + add button --}}
    <div class="mb-4 flex items-center justify-between gap-3">
        <div>
            <h2 class="text-lg font-semibold text-gray-900">Employee Master</h2>
            <p class="text-xs text-gray-500">
                Manage employees, sessions, and active/inactive status for OTP logins.
            </p>
        </div>

        <a href="{{ route('admin.employees.create') }}"
           class="inline-flex items-center rounded-md bg-gray-900 px-3 py-1.5 text-xs font-semibold text-white hover:bg-gray-800">
            + Add New Employee
        </a>
    </div>

    {{-- FILTER FORM --}}
    <form method="GET" class="mb-4 flex flex-wrap gap-3 items-end bg-gray-50 border rounded-md px-3 py-2">
        {{-- Session filter --}}
        <div>
            <label class="block text-[11px] font-semibold mb-1 text-gray-700">Session</label>
            <select name="session_id" class="border rounded px-2 py-1 text-xs">
                <option value="">All sessions</option>
                @foreach($sessions as $s)
                    <option value="{{ $s->id }}" @selected($sessionId == $s->id)>
                        {{ $s->name }}
                    </option>
                @endforeach
            </select>
        </div>

        {{-- Status filter --}}
        <div>
            <label class="block text-[11px] font-semibold mb-1 text-gray-700">Status</label>
            <select name="status" class="border rounded px-2 py-1 text-xs">
                <option value="">All</option>
                <option value="active" @selected($status === 'active')>Active</option>
                <option value="inactive" @selected($status === 'inactive')>Inactive</option>
            </select>
        </div>

        <button type="submit"
                class="mt-1 inline-flex items-center rounded-md bg-gray-900 px-3 py-1.5 text-[11px] font-semibold text-white hover:bg-gray-800">
            Apply Filters
        </button>
    </form>

    {{-- EMPLOYEE TABLE --}}
    <div class="overflow-x-auto bg-white border rounded-lg shadow-sm">
        <table class="min-w-full text-sm">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-3 py-2 text-left text-[11px] font-semibold text-gray-600">Name</th>
                    <th class="px-3 py-2 text-left text-[11px] font-semibold text-gray-600">Email</th>
                    <th class="px-3 py-2 text-left text-[11px] font-semibold text-gray-600">Phone</th>
                    <th class="px-3 py-2 text-left text-[11px] font-semibold text-gray-600">Session(s)</th>
                    <th class="px-3 py-2 text-left text-[11px] font-semibold text-gray-600">Status</th>
                    <th class="px-3 py-2 text-right text-[11px] font-semibold text-gray-600">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($employees as $employee)
                    <tr class="border-t hover:bg-gray-50/60">
                        <td class="px-3 py-2 align-top">
                            <div class="font-semibold text-gray-900 text-sm">{{ $employee->name }}</div>
                            @if($employee->user)
                                <div class="text-[11px] text-gray-500">
                                    Linked User: #{{ $employee->user->id }} ({{ $employee->user->role }})
                                </div>
                            @endif
                        </td>

                        <td class="px-3 py-2 align-top text-gray-800 text-sm">{{ $employee->email }}</td>
                        <td class="px-3 py-2 align-top text-gray-800 text-sm">{{ $employee->phone }}</td>

                        {{-- Sessions --}}
                        <td class="px-3 py-2 align-top text-xs">
                            @if($employee->sessions->isEmpty())
                                <span class="text-gray-400">No session mapped</span>
                            @else
                                <div class="flex flex-wrap gap-1">
                                    @foreach($employee->sessions as $s)
                                        <span class="inline-flex items-center rounded-full bg-gray-100 px-2 py-0.5 text-[11px] text-gray-700">
                                            {{ $s->name }}
                                        </span>
                                    @endforeach
                                </div>
                            @endif
                        </td>

                        {{-- Status badge --}}
                        <td class="px-3 py-2 align-top">
                            @if($employee->is_active)
                                <span class="inline-flex items-center rounded-full bg-green-100 px-2 py-0.5 text-[11px] font-semibold text-green-700">
                                    Active
                                </span>
                            @else
                                <span class="inline-flex items-center rounded-full bg-red-100 px-2 py-0.5 text-[11px] font-semibold text-red-700">
                                    Inactive
                                </span>
                            @endif
                        </td>

                        {{-- Actions: Edit | Delete | Toggle --}}
                        <td class="px-3 py-2 align-top">
                            <div class="flex justify-end gap-2">

                                {{-- Edit --}}
                                <a href="{{ route('admin.employees.edit', $employee) }}"
                                   class="inline-flex items-center rounded border border-gray-300 px-2 py-1 text-[11px] text-gray-700 hover:bg-gray-100">
                                    Edit
                                </a>

                                {{-- Delete --}}
                                <form action="{{ route('admin.employees.destroy', $employee) }}"
                                      method="POST"
                                      onsubmit="return confirm('Delete this employee? This will also disable their login.');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit"
                                            class="inline-flex items-center rounded border border-red-400 px-2 py-1 text-[11px] text-red-600 hover:bg-red-50">
                                        Delete
                                    </button>
                                </form>

                                {{-- Toggle Active / Inactive --}}
                                <form action="{{ route('admin.employees.toggle-active', $employee) }}"
                                      method="POST"
                                      onsubmit="return confirm('Change active status for this employee?');">
                                    @csrf
                                    @method('PATCH')

                                    @if($employee->is_active)
                                        <button type="submit"
                                                class="inline-flex items-center rounded border border-yellow-500 px-2 py-1 text-[11px] text-yellow-700 hover:bg-yellow-50">
                                            Deactivate
                                        </button>
                                    @else
                                        <button type="submit"
                                                class="inline-flex items-center rounded border border-green-500 px-2 py-1 text-[11px] text-green-700 hover:bg-green-50">
                                            Activate
                                        </button>
                                    @endif
                                </form>

                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="px-3 py-4 text-center text-sm text-gray-500">
                            No employees found for the selected filters.
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        {{ $employees->links() }}
    </div>
@endsection
