@php
    // Reusable classes
    $active = "bg-[color:var(--brand-soft)] text-[color:var(--brand-dark)] shadow-sm border border-[color:var(--brand)]/30";
    $idle = "text-[color:var(--sidebar-text)] hover:bg-slate-50 hover:text-[color:var(--brand-dark)] border border-transparent hover:border-[color:var(--sidebar-border)]";
@endphp

<nav id="adminSidebar" class="flex flex-col h-full">

    {{-- Top: Collapse toggle (visible on small screens) --}}
    <div class="flex items-center justify-between px-3 py-3 md:hidden">
        <div class="text-sm font-semibold text-[color:var(--sidebar-muted)]">Admin</div>
        <button id="sidebarToggleMobile" aria-expanded="true" title="Toggle sidebar"
            class="inline-flex items-center justify-center h-9 w-9 rounded-md bg-white border border-[color:var(--sidebar-border)] shadow-sm focus:outline-none focus:ring-2 focus:ring-[color:var(--brand)]">
            <svg id="sidebarToggleIcon" class="w-5 h-5 text-[color:var(--muted)]" viewBox="0 0 24 24" fill="none"
                stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
            </svg>
        </button>
    </div>

    {{-- Wrapper that supports collapsed (icon-only) via `.collapsed` on root --}}
    <div id="sidebarInner" class="overflow-y-auto px-3 py-4 flex-1 flex flex-col transition-all custom-scrollbar">

        {{-- SECTION LABEL --}}
        <div
            class="px-1 pt-1 pb-2 text-[11px] font-semibold text-[color:var(--sidebar-muted)] uppercase tracking-[0.18em] sidebar-section-label">
            Core Navigation
        </div>

        {{-- Link helper: Dashboard --}}
        <a href="{{ route('admin.dashboard') }}"
            class="flex items-center gap-3 px-3 py-2.5 mb-1 rounded-xl text-sm font-medium transition-colors {{ request()->routeIs('admin.dashboard') ? $active : $idle }}"
            title="Dashboard">
            <span
                class="inline-flex h-8 w-8 items-center justify-center rounded-xl bg-[color:var(--brand-soft)] text-[color:var(--brand-dark)]">
                <!-- you can replace emoji with SVG icon -->
                🏠
            </span>
            <span class="sidebar-label">Dashboard</span>
        </a>

        {{-- Leave Management --}}
        {{-- Leave Management (Special Style) --}}
        <a href="{{ route('admin.leaves.index') }}" class="relative flex items-center gap-3 px-3 py-1.5 mb-1 rounded-xl text-sm font-medium transition-all shadow-sm
                  bg-gradient-to-r from-amber-50 to-white border border-amber-200 hover:bg-amber-100">

            {{-- Accent strip --}}
            <span class="absolute left-0 top-0 h-full w-1 rounded-l-xl bg-amber-500"></span>

            <span class="inline-flex h-7 w-7 items-center justify-center rounded-xl bg-amber-100 text-amber-600">
                <span class="text-base">📝</span>
            </span>
            <span class="sidebar-label text-amber-900">Leave Management</span>

            {{-- NEW Badge --}}
            <span
                class="ml-auto text-[9px] font-bold uppercase tracking-wide text-amber-700 bg-amber-100 px-1.5 py-0.5 rounded animate-pulse">
                New
            </span>
        </a>




        {{-- Employee month-wise consolidated --}}
        <a href="{{ route('admin.reports.employee-monthly-conveyance') }}"
            class="flex items-center gap-3 px-3 py-2.5 mb-1 rounded-xl text-sm font-medium transition-colors {{ request()->routeIs('admin.reports.employee-monthly-conveyance') ? $active : $idle }}"
            title="Employee month-wise summary">
            <span
                class="inline-flex h-8 w-8 items-center justify-center rounded-xl bg-slate-100 text-slate-700">📆</span>
            <span class="sidebar-label">Employee month-wise summary</span>
        </a>
        {{-- Client Conveyance --}}
        <a href="{{ route('admin.conveyance.clients') }}"
            class="flex items-center gap-3 px-3 py-2.5 mb-1 rounded-xl text-sm font-medium transition-colors {{ request()->routeIs('admin.conveyance.clients*') ? $active : $idle }}"
            title="Client Conveyance">
            <span
                class="inline-flex h-8 w-8 items-center justify-center rounded-xl bg-slate-100 text-slate-700">📁</span>
            <span class="sidebar-label">Client Conveyance</span>
        </a>

        {{-- Employee Master --}}
        <a href="{{ route('admin.conveyance.employeeMaster') }}"
            class="flex items-center gap-3 px-3 py-2.5 mb-1 rounded-xl text-sm font-medium transition-colors {{ request()->routeIs('admin.conveyance.employeeMaster') ? $active : $idle }}"
            title="Month-wise consolidated">
            <span
                class="inline-flex h-8 w-8 items-center justify-center rounded-xl bg-slate-100 text-slate-700">📊</span>
            <span class="sidebar-label">Month-wise consolidated</span>
        </a>

        {{-- Employee month report --}}
        <a href="{{ route('admin.conveyance.employeeMonthReport') }}"
            class="flex items-center gap-3 px-3 py-2.5 mb-1 rounded-xl text-sm font-medium transition-colors {{ request()->routeIs('admin.conveyance.employeeMonthReport') ? $active : $idle }}"
            title="Employee month comparison">
            <span
                class="inline-flex h-8 w-8 items-center justify-center rounded-xl bg-slate-100 text-slate-700">📅</span>
            <span class="sidebar-label">Employee month comparison</span>
        </a>

        {{-- Expense Report --}}
        <a href="{{ route('admin.expenses.report') }}"
            class="flex items-center gap-3 px-3 py-2.5 mb-1 rounded-xl text-sm font-medium transition-colors {{ request()->routeIs('admin.expenses.report*') ? $active : $idle }}"
            title="Expense Report">
            <span
                class="inline-flex h-8 w-8 items-center justify-center rounded-xl bg-[color:var(--brand-soft)] text-[color:var(--brand-dark)]">📊</span>
            <span class="sidebar-label">Expense Report</span>
        </a>
        <hr class="my-3 border-[color:var(--sidebar-border)]">




        {{-- Employees --}}
        <a href="{{ route('admin.employees.index') }}"
            class="flex items-center gap-3 px-3 py-2.5 mb-1 rounded-xl text-sm font-medium transition-colors {{ request()->routeIs('admin.employees.*') ? $active : $idle }}"
            title="Employees">
            <span class="inline-flex h-8 w-8 items-center justify-center rounded-xl bg-slate-100 text-slate-700">
                👥
            </span>
            <span class="sidebar-label">Employees</span>
        </a>


        {{-- Clients --}}
        <a href="{{ route('admin.clients.index') }}"
            class="flex items-center gap-3 px-3 py-2.5 mb-1 rounded-xl text-sm font-medium transition-colors {{ request()->routeIs('admin.clients.*') ? $active : $idle }}"
            title="Clients">
            <span class="inline-flex h-8 w-8 items-center justify-center rounded-xl bg-slate-100 text-slate-700">
                🏢
            </span>
            <span class="sidebar-label">Clients</span>
        </a>

        {{-- Financial Sessions --}}
        <a href="{{ route('admin.sessions.index') }}"
            class="flex items-center gap-3 px-3 py-2.5 mb-1 rounded-xl text-sm font-medium transition-colors {{ request()->routeIs('admin.sessions.*') ? $active : $idle }}"
            title="Financial Sessions">
            <span class="inline-flex h-8 w-8 items-center justify-center rounded-xl bg-slate-100 text-slate-700">
                📅
            </span>
            <span class="sidebar-label">Financial Sessions</span>
        </a>



        {{-- More links area (flex grow pushes to top) --}}
        <div class="mt-4 flex-1"></div>

        {{-- Footer area: quick actions / sign out --}}
        <div class="pt-3">
            <a href="{{ route('admin.client-requests.index') }}"
                class="flex items-center gap-3 px-3 py-2 mb-2 rounded-xl text-sm font-medium {{ request()->routeIs('admin.client-requests.*') ? $active : $idle }}"
                title="Client Requests">
                <span
                    class="inline-flex h-8 w-8 items-center justify-center rounded-xl bg-slate-100 text-slate-700">📨</span>
                <span class="sidebar-label">Client Requests</span>
                {{-- Example badge: show pending count (uncomment & supply $pendingRequests) --}}
                {{-- <span class="ml-auto text-xs bg-rose-50 text-rose-700 px-2 py-0.5 rounded-full">{{ $pendingRequests
                    }}</span> --}}
            </a>

            <a href="{{ route('admin.employees.create') }}"
                class="flex items-center gap-3 px-3 py-2 mb-2 rounded-xl text-sm font-medium {{ request()->routeIs('admin.employees.create') ? $active : $idle }}"
                title="Add employee">
                <span
                    class="inline-flex h-8 w-8 items-center justify-center rounded-xl bg-slate-100 text-slate-700">➕</span>
                <span class="sidebar-label">Quick Add</span>
            </a>

            <form method="POST" action="{{ route('logout') }}">
                @csrf
                <button type="submit"
                    class="w-full text-left flex items-center gap-3 px-3 py-2 rounded-xl text-sm font-medium text-[color:var(--sidebar-text)] hover:bg-slate-50">
                    <span
                        class="inline-flex h-8 w-8 items-center justify-center rounded-xl bg-slate-100 text-slate-700">🔒</span>
                    <span class="sidebar-label">Sign out</span>
                </button>
            </form>
        </div>
    </div>
</nav>

{{-- Sidebar JS: mobile toggle + collapse to icon-only at very small widths --}}
<script>
    (function () {
        const root = document.getElementById('adminSidebar');
        const inner = document.getElementById('sidebarInner');
        const toggleMobile = document.getElementById('sidebarToggleMobile');
        const icon = document.getElementById('sidebarToggleIcon');

        // mobile toggle: show/hide the inner panel
        if (toggleMobile) {
            toggleMobile.addEventListener('click', () => {
                const expanded = toggleMobile.getAttribute('aria-expanded') === 'true';
                toggleMobile.setAttribute('aria-expanded', String(!expanded));
                if (!expanded) {
                    inner.style.display = 'block';
                    icon.innerHTML = '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>';
                } else {
                    inner.style.display = 'none';
                    icon.innerHTML = '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>';
                }
            });
        }

        // collapse-to-icons behaviour on very small screens: add tooltip via title attribute (handled by browser)
        // keep ready for future enhancement (e.g., localStorage for preference)
        // Ensure sidebarInner is visible on md+ by resetting inline style
        function onResize() {
            if (window.innerWidth >= 768) {
                inner.style.display = 'block';
            } else {
                // start collapsed on small by default (but toggle can open)
                if (!toggleMobile || toggleMobile.getAttribute('aria-expanded') === 'false') {
                    inner.style.display = 'none';
                }
            }
        }
        window.addEventListener('resize', onResize);
        onResize();
    })();
</script>

{{-- Small CSS specific to sidebar --}}
<style>
    /* Ensure labels hide gracefully if later you want icon-only mode (not currently used) */
    .sidebar-label {
        white-space: nowrap;
    }

    /* make the rounded icon centers same across */
    nav .inline-flex.rounded-xl {
        min-width: 2rem;
        min-height: 2rem;
    }

    /* mobile: give sidebar a subtle top padding so it doesn't butt to header */
    @media (max-width: 767px) {
        #adminSidebar {
            background: transparent;
        }
    }

    /* Custom Scrollbar for Sidebar */
    .custom-scrollbar::-webkit-scrollbar {
        width: 4px;
    }

    .custom-scrollbar::-webkit-scrollbar-track {
        background: transparent;
    }

    .custom-scrollbar::-webkit-scrollbar-thumb {
        background-color: #cbd5e1;
        /* slate-300 */
        border-radius: 4px;
    }

    .custom-scrollbar::-webkit-scrollbar-thumb:hover {
        background-color: #94a3b8;
        /* slate-400 */
    }
</style>