@extends('layouts.admin_fullwidth')

@section('page-title', 'Employee – Month-wise Consolidated Conveyance')
@section('page-subtitle', 'Session: ' . ($activeSession->name ?? ($activeSession->label ?? 'Active')))

@section('content')

    @php
        $totalEmployees = count($rows);
    @endphp

    <div class="-mx-4 -mt-4 px-4 pb-8 md:px-6 lg:px-8">

        {{-- Top actions + summary (hide in Excel export) --}}
        @empty($isExport)
            <div class="flex flex-col gap-3 md:flex-row md:items-center md:justify-between mb-4">
                <div class="space-y-1">
                    <div class="flex items-center gap-2 text-xs text-slate-500">
                        <a href="{{ route('admin.dashboard') }}" class="inline-flex items-center gap-1 hover:underline">
                            <span class="text-base leading-none">&larr;</span>
                            <span>Back to Dashboard</span>
                        </a>
                        <span class="hidden md:inline">|</span>
                        <span>Session:
                            <span class="font-semibold text-slate-700">
                                {{ $activeSession->name ?? ($activeSession->label ?? '') }}
                            </span>
                        </span>
                    </div>
                    <h2 class="text-lg md:text-xl font-semibold text-slate-800">
                        Employee × Month-wise Consolidated Conveyance
                    </h2>
                    <p class="text-xs md:text-sm text-slate-500">
                        Each cell shows total submitted conveyance (onward + return, where applicable)
                        for that employee in the given month of the active session.
                    </p>
                </div>

                <div class="flex flex-wrap gap-2 justify-start md:justify-end">
                    <button onclick="window.print()"
                        class="inline-flex items-center rounded-md border border-slate-300 px-3 py-1.5 text-xs font-medium text-slate-700 bg-white hover:bg-slate-50">
                        🖨 Print
                    </button>

                    <a href="{{ route('admin.reports.employee-monthly-conveyance.export') }}"
                        class="inline-flex items-center rounded-md border border-emerald-600 px-3 py-1.5 text-xs font-semibold text-emerald-700 bg-emerald-50 hover:bg-emerald-100">
                        ⬇ Export to Excel
                    </a>
                </div>
            </div>

            {{-- Small KPI bar --}}
            <div class="grid grid-cols-1 md:grid-cols-3 gap-3 mb-4">
                <div class="rounded-lg border border-slate-200 bg-white px-4 py-3">
                    <p class="text-[11px] uppercase tracking-wide text-slate-500">Employees</p>
                    <p class="mt-1 text-lg font-semibold text-slate-800">
                        {{ $totalEmployees }}
                    </p>
                </div>
                <div class="rounded-lg border border-slate-200 bg-white px-4 py-3">
                    <p class="text-[11px] uppercase tracking-wide text-slate-500">Overall Total</p>
                    <p class="mt-1 text-lg font-semibold text-slate-800">
                        ₹ {{ number_format($overallTotal, 2) }}
                    </p>
                </div>
                <div class="rounded-lg border border-slate-200 bg-white px-4 py-3">
                    <p class="text-[11px] uppercase tracking-wide text-slate-500">Months Covered</p>
                    <p class="mt-1 text-sm font-semibold text-slate-800">
                        @if(count($months))
                            {{ $months[0]['label'] }} – {{ $months[count($months) - 1]['label'] }}
                        @else
                            N/A
                        @endif
                    </p>
                </div>
            </div>
        @endempty

        {{-- Table container --}}
        <div class="rounded-lg border border-slate-200 bg-white shadow-sm overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full text-xs md:text-sm border-collapse">
                    <thead>
                        <tr class="bg-slate-50">
                            <th
                                class="sticky left-0 z-20 border-b border-r border-slate-200 bg-slate-50 px-3 py-2 text-left text-[11px] font-semibold uppercase tracking-wide text-slate-500">
                                Employee
                            </th>

                            @foreach($months as $m)
                                <th
                                    class="border-b border-slate-200 px-3 py-2 text-right text-[11px] font-semibold uppercase tracking-wide text-slate-500 whitespace-nowrap">
                                    {{ $m['label'] }}
                                </th>
                            @endforeach

                            <th
                                class="border-b border-l border-slate-200 px-3 py-2 text-right text-[11px] font-semibold uppercase tracking-wide text-slate-500 whitespace-nowrap">
                                Grand&nbsp;Total
                            </th>
                        </tr>
                    </thead>

                    <tbody>
                        @forelse($rows as $row)
                            @php
                                $user = $row['user'];
                            @endphp
                            <tr class="odd:bg-white even:bg-slate-50/40 hover:bg-emerald-50/40">
                                {{-- Employee name (frozen first column) --}}
                                <td
                                    class="sticky left-0 z-10 border-t border-r border-slate-200 bg-inherit px-3 py-2 text-xs md:text-sm font-medium text-slate-800 whitespace-nowrap">
                                    {{ $user->name ?? ('User #' . $user->id) }}
                                </td>

                                {{-- Per month --}}
                                @foreach($months as $m)
                                    @php
                                        $key = $m['key'];
                                        $val = $row['monthly'][$key] ?? 0;
                                    @endphp
                                    <td
                                        class="border-t border-slate-200 px-3 py-2 text-right align-middle text-[11px] md:text-xs text-slate-700">
                                        @if($val > 0)
                                            ₹ {{ number_format($val, 2) }}
                                        @else
                                            <span class="text-slate-300">—</span>
                                        @endif
                                    </td>
                                @endforeach

                                {{-- Grand total per employee --}}
                                <td
                                    class="border-t border-l border-slate-200 px-3 py-2 text-right align-middle text-xs md:text-sm font-semibold text-slate-900">
                                    @if($row['grand_total'] > 0)
                                        ₹ {{ number_format($row['grand_total'], 2) }}
                                    @else
                                        <span class="text-slate-300">—</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="{{ 1 + count($months) + 1 }}" class="px-3 py-4 text-center text-xs text-slate-500">
                                    No submitted conveyance found for this session.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>

                    {{-- Overall footer row (only in HTML, not necessary but nice) --}}
                    @if(!empty($rows))
                        <tfoot class="bg-slate-50">
                            <tr>
                                <th
                                    class="sticky left-0 z-10 border-t border-r border-slate-200 bg-slate-50 px-3 py-2 text-xs font-semibold text-slate-800 text-left">
                                    TOTAL
                                </th>
                                @foreach($months as $m)
                                                        @php
                                                            $key = $m['key'];
                                                            $sumForMonth = 0;
                                                            foreach ($rows as $row) {
                                                                $sumForMonth += $row['monthly'][$key] ?? 0;
                                                            }
                                                        @endphp
                                     <th
                                                            class="border-t border-slate-200 px-3 py-2 text-right text-[11px] font-semibold text-slate-800">
                                                            @if($sumForMonth > 0)
                                                                ₹ {{ number_format($sumForMonth, 2) }}
                                                            @else
                                                                <span class="text-slate-300">—</span>
                                                            @endif
                                                        </th>
                                @endforeach
                                <th
                                    class="border-t border-l border-slate-200 px-3 py-2 text-right text-xs font-semibold text-slate-900">
                                    ₹ {{ number_format($overallTotal, 2) }}
                                </th>
                            </tr>
                        </tfoot>
                    @endif
                </table>
            </div>
        </div>
    </div>

@endsection