<table>
    <thead>
        <tr>
            <th>Employee</th>

            @foreach($months as $m)
                <th>{{ $m['label'] }}</th>
            @endforeach

            <th>Grand Total</th>
        </tr>
    </thead>

    <tbody>
        @foreach($rows as $row)
            <tr>
                <td>{{ $row['user']->name }}</td>

                @foreach($months as $m)
                    @php
                        $key = $m['key'];
                        $val = $row['monthly'][$key] ?? 0;
                    @endphp
                    <td>{{ $val > 0 ? number_format($val, 2) : '' }}</td>
                @endforeach

                <td>{{ number_format($row['grand_total'], 2) }}</td>
            </tr>
        @endforeach
    </tbody>

    <tfoot>
        <tr>
            <th>Total</th>

            @foreach($months as $m)
                @php
                    $key = $m['key'];
                    $sumForMonth = 0;
                    foreach ($rows as $row) {
                        $sumForMonth += $row['monthly'][$key] ?? 0;
                    }
                @endphp
                <th>{{ $sumForMonth > 0 ? number_format($sumForMonth, 2) : '' }}</th>
            @endforeach

            <th>{{ number_format($overallTotal, 2) }}</th>
        </tr>
    </tfoot>
</table>
