@extends('layouts.admin')

@section('page-title', 'Create Financial Session')
@section('page-subtitle', 'Define a financial year for conveyance tracking')

@section('content')

<div class="mb-6 flex flex-col md:flex-row md:items-center md:justify-between gap-3">
    <div>
        <h2 class="text-xl md:text-2xl font-extrabold tracking-tight">Create Financial Session</h2>
        <p class="text-sm text-[color:var(--muted)] mt-1">
            Add a new financial session with a clear start and end date.
        </p>
    </div>
    <a href="{{ route('admin.sessions.index') }}"
       class="inline-flex items-center gap-2 px-4 py-2.5 rounded-xl bg-[color:var(--bg-2)] border border-[color:var(--border)] text-sm font-semibold text-[color:var(--brand-dark)] hover:bg-slate-100 transition">
        <span class="text-base">←</span> Back to Sessions
    </a>
</div>

<div class="grid lg:grid-cols-3 gap-5">

    {{-- Form Card --}}
    <div class="lg:col-span-2 max-w-xl rounded-3xl bg-[color:var(--surface)] p-6 border border-[color:var(--border)] shadow-sm">
        <div class="mb-4">
            <h3 class="text-lg font-semibold">Session details</h3>
            <p class="text-xs text-[color:var(--muted)] mt-1">
                Use a consistent naming pattern like <span class="font-semibold text-[color:var(--text)]">2025–2026</span>.
            </p>
        </div>

        <form method="POST"
              action="{{ route('admin.sessions.store') }}"
              class="space-y-4">
            @csrf

            {{-- Session Name --}}
            <div>
                <label class="text-sm font-medium text-[color:var(--text)] block mb-1.5">
                    Session Name
                </label>
                <input name="name"
                       value="{{ old('name') }}"
                       placeholder="2025-2026"
                       class="w-full border border-[color:var(--border)] rounded-xl px-3 py-2.5 text-sm
                              focus:outline-none focus:ring-2 focus:ring-[color:var(--brand)] focus:border-[color:var(--brand)]
                              placeholder:text-slate-400"
                       required>
            </div>

            {{-- Start Date --}}
            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm font-medium text-[color:var(--text)] block mb-1.5">
                        Start Date
                    </label>
                    <input type="date"
                           name="start_date"
                           value="{{ old('start_date') }}"
                           class="w-full border border-[color:var(--border)] rounded-xl px-3 py-2.5 text-sm
                                  focus:outline-none focus:ring-2 focus:ring-[color:var(--brand)] focus:border-[color:var(--brand)]"
                           required>
                </div>

                {{-- End Date --}}
                <div>
                    <label class="text-sm font-medium text-[color:var(--text)] block mb-1.5">
                        End Date
                    </label>
                    <input type="date"
                           name="end_date"
                           value="{{ old('end_date') }}"
                           class="w-full border border-[color:var(--border)] rounded-xl px-3 py-2.5 text-sm
                                  focus:outline-none focus:ring-2 focus:ring-[color:var(--brand)] focus:border-[color:var(--brand)]"
                           required>
                </div>
            </div>

            <div class="pt-2">
                <button
                    class="w-full md:w-auto inline-flex items-center justify-center gap-2 px-5 py-2.5 rounded-xl
                           bg-[color:var(--brand)] text-white text-sm font-semibold
                           hover:bg-[color:var(--brand-dark)] transition shadow-sm">
                    Save Session
                </button>
            </div>
        </form>
    </div>

    {{-- Side Info --}}
    <div class="rounded-3xl bg-[color:var(--surface)] border border-[color:var(--border)] shadow-sm p-5 max-w-md">
        <h4 class="text-sm font-semibold mb-2">Tips for session setup</h4>
        <ul class="text-xs text-[color:var(--muted)] space-y-1.5">
            <li>• One session usually maps to a financial year (e.g., 2025–2026).</li>
            <li>• Ensure dates do not overlap with previously active sessions.</li>
            <li>• Only <span class="font-semibold text-[color:var(--text)]">one session</span> should be active at a time for clarity in reports.</li>
        </ul>

        <div class="mt-4 p-3 rounded-2xl bg-[color:var(--bg-2)] text-[11px] text-[color:var(--muted)] border border-[color:var(--border)]">
            <div class="font-semibold text-[color:var(--text)] mb-1">Note</div>
            After creation, you can mark a session as active from the Sessions list.
        </div>
    </div>
</div>

@endsection
