@extends('layouts.admin')

@section('page-title', 'Financial Sessions')
@section('page-subtitle', 'Manage financial years and active session')

@section('content')

<div class="flex flex-col md:flex-row md:items-center md:justify-between gap-3 mb-5">
    <div>
        <h2 class="text-xl md:text-2xl font-extrabold tracking-tight">Financial Sessions</h2>
        <p class="text-sm text-[color:var(--muted)] mt-1">
            Overview of all financial sessions and control of which one is active.
        </p>
    </div>

    <a href="{{ route('admin.sessions.create') }}"
       class="inline-flex items-center gap-2 px-4 py-2.5 rounded-xl bg-[color:var(--brand)] text-white text-sm font-semibold hover:bg-[color:var(--brand-dark)] transition shadow-sm">
        + Create Session
    </a>
</div>

<div class="rounded-2xl bg-[color:var(--surface)] border border-[color:var(--border)] shadow-sm overflow-hidden">
    <div class="px-4 py-3 border-b border-[color:var(--border)] flex items-center justify-between">
        <div class="text-sm text-[color:var(--muted)]">
            Total sessions: <span class="font-semibold text-[color:var(--text)]">{{ $sessions->count() }}</span>
        </div>
        <div class="text-[11px] text-[color:var(--muted)]">
            Only one session should be marked as
            <span class="font-semibold text-emerald-600">Active</span>.
        </div>
    </div>

    <div class="overflow-x-auto">
        <table class="w-full text-sm">
            <thead class="bg-slate-50 text-[11px] uppercase tracking-wide text-[color:var(--muted)]">
                <tr>
                    <th class="p-3 text-left font-semibold">Session</th>
                    <th class="p-3 text-left font-semibold">Start</th>
                    <th class="p-3 text-left font-semibold">End</th>
                    <th class="p-3 text-center font-semibold">Status</th>
                    <th class="p-3 text-right font-semibold">Action</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-[color:var(--border)]">
                @forelse($sessions as $s)
                    <tr class="hover:bg-slate-50/70 transition">
                        <td class="p-3 font-semibold text-[color:var(--text)]">
                            {{ $s->name }}
                        </td>
                        <td class="p-3 text-[color:var(--muted)]">
                            {{ $s->start_date->format('d M Y') }}
                        </td>
                        <td class="p-3 text-[color:var(--muted)]">
                            {{ $s->end_date->format('d M Y') }}
                        </td>
                        <td class="p-3 text-center">
                            @if($s->is_active)
                                <span class="inline-flex items-center gap-1 px-2.5 py-1 text-[11px] rounded-full bg-emerald-50 text-emerald-700 border border-emerald-200">
                                    <span class="h-1.5 w-1.5 rounded-full bg-emerald-500"></span>
                                    Active
                                </span>
                            @else
                                <span class="inline-flex items-center gap-1 px-2.5 py-1 text-[11px] rounded-full bg-slate-50 text-slate-600 border border-slate-200">
                                    Inactive
                                </span>
                            @endif
                        </td>
                        <td class="p-3 text-right">
                            @if(!$s->is_active)
                                <form method="POST" action="{{ route('admin.sessions.activate',$s->id) }}" class="inline-block">
                                    @csrf
                                    <button
                                        class="inline-flex items-center gap-1 text-[11px] font-semibold text-[color:var(--brand-dark)] hover:text-[color:var(--brand)]">
                                        Activate
                                    </button>
                                </form>
                            @else
                                <span class="text-[11px] text-[color:var(--muted)]">Current active</span>
                            @endif
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="p-4 text-center text-[13px] text-[color:var(--muted)]">
                            No sessions created yet. Click “Create Session” to add your first financial year.
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>

@endsection

