@extends('layouts.app')
@section('content')

<div class="min-h-[80vh] grid place-items-center">
  <div class="w-full max-w-md relative">
    <div class="absolute -inset-6 rounded-[2rem] bg-gradient-to-br from-blue-500/20 via-sky-400/10 to-emerald-500/20 blur-2xl"></div>

    <div class="relative bg-white/90 backdrop-blur rounded-2xl border border-slate-200 shadow-xl p-7">
      <div class="text-center mb-6">
        <div class="mx-auto h-14 w-14 rounded-2xl bg-gradient-to-br from-blue-600 to-emerald-500 grid place-items-center text-white text-2xl font-extrabold shadow-md">
          P
        </div>
        <h2 class="text-2xl font-extrabold mt-3">Login with OTP</h2>
        <p class="text-sm text-slate-500 mt-1">
          Enter your registered email to receive a secure OTP.
        </p>
      </div>

      <form method="POST" action="{{ route('otp.send') }}" class="space-y-4">
        @csrf
        <div>
          <label class="text-sm font-semibold text-slate-700">Registered Email</label>
          <div class="mt-1 relative">
            <input name="identifier" type="email" placeholder="employee@pactech.com" required
              class="w-full border border-slate-300 rounded-xl px-4 py-2.5 pr-10
                     focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500
                     bg-white text-slate-800 shadow-sm">
            <span class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-400">✉️</span>
          </div>
          <p class="text-xs text-slate-500 mt-1">
            Only PAC Technology registered employees can login.
          </p>
        </div>

        <button class="w-full bg-gradient-to-r from-blue-600 to-emerald-600 text-white py-2.5 rounded-xl
                       font-semibold hover:brightness-110 transition shadow-md">
          Send OTP
        </button>
      </form>
    </div>
  </div>
</div>

@endsection
