@extends('layouts.app')
@section('content')

<div class="min-h-[80vh] grid place-items-center">
  <div class="w-full max-w-md relative">
    <div class="absolute -inset-6 rounded-[2rem] bg-gradient-to-br from-emerald-500/20 via-sky-400/10 to-blue-500/20 blur-2xl"></div>

    <div class="relative bg-white/90 backdrop-blur rounded-2xl border border-slate-200 shadow-xl p-7">
      <div class="text-center mb-6">
        <div class="mx-auto h-14 w-14 rounded-2xl bg-gradient-to-br from-emerald-600 to-blue-600 grid place-items-center text-white text-2xl font-extrabold shadow-md">
          ✓
        </div>
        <h2 class="text-2xl font-extrabold mt-3">Verify OTP</h2>
        <p class="text-sm text-slate-500 mt-1">
          OTP sent to {{ session('otp_identifier') }}
        </p>
      </div>

      <form method="POST" action="{{ route('otp.verify') }}" class="space-y-4">
        @csrf
        <input name="otp"
          class="w-full border border-slate-300 rounded-xl px-3 py-2.5 text-center tracking-widest text-lg
                 focus:ring-2 focus:ring-emerald-500 focus:border-emerald-500"
          placeholder="123456" required>

        <button class="w-full bg-gradient-to-r from-emerald-600 to-blue-600 text-white py-2.5 rounded-xl
                       font-semibold hover:brightness-110 transition shadow-md">
          Verify & Login
        </button>
      </form>

      <form method="POST" action="{{ route('otp.send') }}" class="mt-3">
        @csrf
        <input type="hidden" name="identifier" value="{{ session('otp_identifier') }}">
        <button class="w-full text-sm text-blue-600 underline">Resend OTP</button>
      </form>
    </div>
  </div>
</div>

@endsection
