@extends('layouts.employee')

@section('page-title', $currentMonthLabel . ' Claims')
@section('page-subtitle', 'Manage your current travel expenses')

@section('content')

    <div class="mb-6">
        <div class="flex flex-col md:flex-row md:items-center justify-between gap-4 mb-6">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">{{ $currentMonthLabel }}</h1>
                <p class="text-sm text-gray-500 mt-1">
                    Submission Window: <span class="font-medium text-gray-700">{{ $monthStart->format('d M') }} - {{ $cutoffDate->format('d M') }}</span>
                    @if($today->gt($cutoffDate))
                        <span class="ml-2 inline-flex items-center px-2 py-0.5 rounded text-xs font-semibold bg-red-100 text-red-700">
                            Window Closed
                        </span>
                    @else
                        <span class="ml-2 inline-flex items-center px-2 py-0.5 rounded text-xs font-semibold bg-emerald-100 text-emerald-700">
                            Active
                        </span>
                    @endif
                </p>
            </div>

            <div class="flex items-center gap-3">
                 <a href="{{ route('employee.conveyance.history') }}" class="px-4 py-2 bg-white border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition shadow-sm">
                    View History
                </a>
                
                @if($totals['draft'] > 0 && $today->lte($cutoffDate))
                    <form method="POST" action="{{ route('employee.conveyance.submitAll') }}" onsubmit="return confirm('Are you sure you want to submit all draft entries? This cannot be undone.');">
                        @csrf
                        <button type="submit" class="px-4 py-2 bg-indigo-600 text-white text-sm font-medium rounded-lg hover:bg-indigo-700 transition shadow-sm flex items-center gap-2">
                             <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                            </svg>
                            Submit All Drafts
                        </button>
                    </form>
                @endif
                
                @if($today->lte($cutoffDate))
                    <a href="{{ route('employee.conveyance.create') }}" class="px-4 py-2 bg-emerald-600 text-white text-sm font-medium rounded-lg hover:bg-emerald-700 transition shadow-sm flex items-center gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                        </svg>
                        New Entry
                    </a>
                @endif
            </div>
        </div>

        <!-- Stats Cards -->
        <div class="grid grid-cols-1 sm:grid-cols-3 gap-4 mb-6">
            <div class="bg-white border border-gray-200 rounded-xl p-4 shadow-sm flex items-center justify-between">
                <div>
                     <p class="text-xs font-medium text-gray-500 uppercase tracking-wide">Submitted</p>
                     <p class="text-xl font-bold text-gray-900 mt-1">₹{{ number_format($totals['submitted']) }}</p>
                </div>
                <div class="w-10 h-10 rounded-full bg-emerald-50 flex items-center justify-center text-emerald-600">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                </div>
            </div>

            <div class="bg-white border border-gray-200 rounded-xl p-4 shadow-sm flex items-center justify-between">
                <div>
                     <p class="text-xs font-medium text-gray-500 uppercase tracking-wide">Draft</p>
                     <p class="text-xl font-bold text-amber-600 mt-1">₹{{ number_format($totals['draft']) }}</p>
                </div>
                 <div class="w-10 h-10 rounded-full bg-amber-50 flex items-center justify-center text-amber-600">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                    </svg>
                </div>
            </div>

            <div class="bg-gradient-to-br from-indigo-500 to-purple-600 rounded-xl p-4 shadow-md text-white flex items-center justify-between">
                 <div>
                     <p class="text-xs font-medium text-indigo-100 uppercase tracking-wide">Total Claims</p>
                     <p class="text-xl font-bold mt-1">₹{{ number_format($totals['submitted'] + $totals['draft']) }}</p>
                </div>
                 <div class="w-10 h-10 rounded-full bg-white/20 flex items-center justify-center text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                </div>
            </div>
        </div>

        <!-- Main Table -->
        <div class="bg-white border border-gray-200 rounded-xl shadow-sm overflow-hidden">
             @if($conveyances->isEmpty())
                <div class="p-12 text-center">
                    <div class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-gray-50 text-gray-400 mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 13h6m-3-3v6m5 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                        </svg>
                    </div>
                    <h3 class="text-lg font-medium text-gray-900">No entries yet</h3>
                    <p class="text-gray-500 mt-1 mb-6">Start by adding your first conveyance claim for this month.</p>
                     @if($today->lte($cutoffDate))
                        <a href="{{ route('employee.conveyance.create') }}" class="inline-flex items-center px-4 py-2 bg-emerald-600 text-white text-sm font-medium rounded-lg hover:bg-emerald-700 transition shadow-sm">
                            + Add Entry
                        </a>
                     @endif
                </div>
             @else
                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-gray-50 border-b border-gray-200 text-xs text-gray-500 uppercase tracking-wider font-semibold">
                                <th class="p-4 w-24 text-center">Date</th>
                                <th class="p-4 w-1/4">Route / Mode</th>
                                <th class="p-4 w-1/4">Client / Purpose</th>
                                <th class="p-4 text-right">Amount</th>
                                <th class="p-4 text-center">Return</th>
                                <th class="p-4 text-center">Status</th>
                                <th class="p-4 text-center w-32">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 text-sm text-gray-700">
                             @foreach($conveyances as $c)
                                @php
                                    $rowTotal = $c->total_amount;
                                    // Allow edit/delete if within window, regardless of status (draft OR submitted)
                                    $canEdit = $today->lte($cutoffDate);
                                @endphp
                                <tr class="hover:bg-gray-50 transition duration-75 group">
                                    <td class="p-4 text-center">
                                        <div class="font-bold text-gray-900">{{ $c->date->format('d M') }}</div>
                                        <div class="text-xs text-gray-400">{{ $c->date->format('D') }}</div>
                                    </td>
                                    <td class="p-4">
                                        <div class="flex items-center gap-2 mb-1">
                                            <span class="font-medium text-gray-900">{{ $c->from_location }}</span>
                                            <span class="text-gray-300">→</span>
                                            <span class="font-medium text-gray-900">{{ $c->to_location }}</span>
                                        </div>
                                         <span class="inline-flex items-center px-1.5 py-0.5 rounded text-[10px] font-medium bg-gray-100 text-gray-600 border border-gray-200">
                                            {{ $c->mode }}
                                        </span>
                                    </td>
                                    <td class="p-4">
                                         @if($c->client)
                                            <div class="font-semibold text-gray-900">{{ $c->client->name }}</div>
                                         @else
                                            <div class="text-gray-400 italic">No Client</div>
                                         @endif
                                         
                                         @if($c->remarks)
                                            <div class="text-xs text-gray-500 mt-1 max-w-xs truncate" title="{{ $c->remarks }}">{{ $c->remarks }}</div>
                                         @endif
                                    </td>
                                    <td class="p-4 text-right font-mono font-bold text-gray-900">
                                        ₹{{ number_format($rowTotal, 2) }}
                                    </td>
                                    <td class="p-4 text-center">
                                         @if($c->is_return)
                                            <div class="inline-flex items-center justify-center w-6 h-6 rounded-md bg-emerald-50 text-emerald-600">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" aria-hidden="true" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                                </svg>
                                            </div>
                                             @if($c->return_amount)
                                                <div class="text-[10px] text-gray-400 mt-0.5 font-mono">Custom</div>
                                            @endif
                                        @else
                                            <span class="text-gray-300">—</span>
                                        @endif
                                    </td>
                                    <td class="p-4 text-center">
                                        @if($c->status === 'draft')
                                            <span class="inline-flex px-2.5 py-1 rounded-full text-xs font-bold bg-amber-50 text-amber-600 border border-amber-200">
                                                Draft
                                            </span>
                                        @else
                                            <span class="inline-flex px-2.5 py- 1 rounded-full text-xs font-bold bg-emerald-50 text-emerald-600 border border-emerald-200">
                                                Submitted
                                            </span>
                                        @endif
                                    </td>
                                    <td class="p-4 text-center">
                                        @if($canEdit)
                                            <div class="flex items-center justify-center gap-2">
                                                <a href="{{ route('employee.conveyance.edit', $c) }}" class="p-1.5 text-blue-600 bg-blue-50 rounded-lg hover:bg-blue-100 transition" title="Edit">
                                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                                                    </svg>
                                                </a>
                                                <form method="POST" action="{{ route('employee.conveyance.destroy', $c) }}" onsubmit="return confirm('Are you sure you want to delete this entry?');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="p-1.5 text-rose-600 bg-rose-50 rounded-lg hover:bg-rose-100 transition" title="Delete">
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                                        </svg>
                                                    </button>
                                                </form>
                                            </div>
                                        @else
                                             <span class="text-gray-300 text-xs">Locked</span>
                                        @endif
                                    </td>
                                </tr>
                             @endforeach
                        </tbody>
                    </table>
                </div>
             @endif
        </div>
    </div>

@endsection