@extends('layouts.employee')

@section('page-title', $currentMonthLabel . ' History')
@section('page-subtitle', 'Verified claim details')

@section('content')

    <style>
        /* Shared Table Styles */
        thead th {
            position: sticky;
            top: 0;
            z-index: 10;
            background-color: #f3f4f6;
            box-shadow: 0 1px 2px rgba(0, 0, 0, 0.05);
        }

        tbody tr:nth-child(even) {
            background-color: #f9fafb;
        }

        tbody tr:hover {
            background-color: #f0f9ff;
        }
    </style>

    <div class="mb-6">
        <div class="flex items-center justify-between mb-4">
            <div>
                <h1 class="text-xl font-bold text-gray-900">{{ $currentMonthLabel }} Report</h1>
                <p class="text-sm text-gray-500">
                    Verified submission for {{ $monthStart->format('F Y') }}
                </p>
            </div>
            <a href="{{ route('employee.conveyance.history') }}"
                class="px-3 py-1.5 bg-white border border-gray-300 text-gray-700 text-sm font-medium rounded hover:bg-gray-50 transition shadow-sm">
                ← Back to History
            </a>
        </div>

        <!-- Summary Cards -->
        <div class="grid grid-cols-2 lg:grid-cols-4 gap-4">
            <div class="bg-indigo-50 border border-indigo-100 rounded-lg p-3">
                <div class="text-xs font-semibold text-indigo-800 uppercase">Total Amount</div>
                <div class="text-lg font-bold text-indigo-900 mt-1">₹{{ number_format($monthTotalSubmitted) }}</div>
            </div>
            <div class="bg-white border border-gray-200 rounded-lg p-3">
                <div class="text-xs font-semibold text-gray-500 uppercase">Entries</div>
                <div class="text-lg font-bold text-gray-900 mt-1">{{ $conveyances->count() }}</div>
            </div>
        </div>
    </div>

    <!-- Main Table (Enterprise Style) -->
    <div class="bg-white border border-gray-300 rounded-lg shadow-sm overflow-hidden">
        <div class="max-h-[600px] overflow-auto">
            <table class="w-full text-left border-collapse text-sm">
                <thead>
                    <tr class="text-xs text-gray-700 uppercase tracking-wide border-b border-gray-300">
                        <th class="p-3 border-r border-gray-300 text-center w-24">Date</th>
                        <th class="p-3 border-r border-gray-300 w-1/4">Route</th>
                        <th class="p-3 border-r border-gray-300 w-1/4">Client / Remarks</th>
                        <th class="p-3 border-r border-gray-300 w-24 text-center">Mode</th>
                        <th class="p-3 border-r border-gray-300 w-32 text-right">Amount</th>
                        <th class="p-3 text-center w-24">Return</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200">
                    @forelse($conveyances as $c)
                        @php
                            $rowTotal = $c->total_amount;
                            $isSunday = $c->date->isSunday();
                        @endphp
                        <tr class="{{ $isSunday ? 'bg-orange-50' : '' }}">
                            <td class="p-3 border-r border-gray-200 text-center">
                                <span class="block font-bold text-gray-900">{{ $c->date->format('d') }}</span>
                                <span class="block text-xs uppercase text-gray-500">{{ $c->date->format('D') }}</span>
                            </td>
                            <td class="p-3 border-r border-gray-200">
                                <div class="flex items-center gap-1.5 text-gray-900 font-medium">
                                    {{ $c->from_location }}
                                    <span class="text-gray-400">→</span>
                                    {{ $c->to_location }}
                                </div>
                            </td>
                            <td class="p-3 border-r border-gray-200">
                                @if($c->client)
                                    <div class="font-semibold text-indigo-900 text-xs">{{ $c->client->name }}</div>
                                @endif
                                @if($c->remarks)
                                    <div class="text-gray-500 text-xs mt-0.5">{{ $c->remarks }}</div>
                                @endif
                            </td>
                            <td class="p-3 border-r border-gray-200 text-center text-xs">
                                <span class="px-1.5 py-0.5 rounded border border-gray-200 bg-gray-50">
                                    {{ $c->mode }}
                                </span>
                            </td>
                            <td class="p-3 border-r border-gray-200 text-right font-mono font-bold text-gray-900">
                                ₹{{ number_format($rowTotal, 2) }}
                            </td>
                            <td class="p-3 text-center">
                                @if($c->is_return)
                                    <span class="text-emerald-600 font-bold text-xs">Yes</span>
                                    @if($c->return_amount)
                                        <div class="text-[10px] text-gray-400">(₹{{ $c->return_amount }})</div>
                                    @endif
                                @else
                                    <span class="text-gray-300">-</span>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="p-8 text-center text-gray-500">
                                No records found for this period.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
                @if($conveyances->isEmpty() === false)
                    <tfoot class="bg-gray-50 border-t border-gray-300">
                        <tr>
                            <td colspan="4" class="p-3 text-right font-bold text-gray-700 uppercase text-xs">Total Claimed</td>
                            <td class="p-3 text-right font-bold text-lg text-emerald-700 border-l border-gray-300">
                                ₹{{ number_format($monthTotalSubmitted, 2) }}
                            </td>
                            <td></td>
                        </tr>
                    </tfoot>
                @endif
            </table>
        </div>
    </div>

@endsection