@extends('layouts.employee')

@section('page-title', 'Dashboard')
@section('page-subtitle', 'Overview of your conveyance activity')

@section('content')

    @php
        $today = now()->format('d M Y');
    @endphp

    {{-- Hero --}}
    <div class="rounded-3xl bg-[color:var(--emp-surface)] border border-[color:var(--emp-border)] shadow-sm p-5 mb-5">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-3">
            <div>
                <h2 class="text-xl md:text-2xl font-extrabold tracking-tight">
                    Welcome, {{ auth()->user()->name ?? 'Employee' }} 👋
                </h2>
                <p class="text-sm text-[color:var(--emp-muted)] mt-1">
                    Today is <span class="font-semibold text-[color:var(--emp-text)]">{{ $today }}</span>.
                    You are working in
                    <span class="font-semibold">
                        {{ $currentMonthLabel ?? 'Current Month' }}
                    </span>
                    window ({{ $monthStart->format('d M') }} – {{ $monthEnd->format('d M Y') }}).
                </p>
                @if($activeSession)
                    <p class="text-xs text-[color:var(--emp-muted)] mt-1">
                        Active Financial Session:
                        <span class="font-semibold text-[color:var(--emp-text)]">{{ $activeSession->name }}</span>
                    </p>
                @endif
            </div>

            <div class="flex gap-2 flex-wrap">
                <a href="{{ route('employee.conveyance.create') }}"
                    class="inline-flex items-center gap-2 px-4 py-2.5 rounded-xl bg-[color:var(--emp-brand)] text-white text-xs md:text-sm font-semibold hover:bg-blue-700 transition shadow-sm">
                    <span>➕</span> Add Conveyance
                </a>
                <a href="{{ route('employee.conveyance.index') }}"
                    class="inline-flex items-center gap-2 px-4 py-2.5 rounded-xl bg-[color:var(--emp-bg-soft)] text-[color:var(--emp-text)] text-xs md:text-sm font-semibold border border-[color:var(--emp-border)] hover:bg-slate-100 transition">
                    📋 View My Conveyance
                </a>
            </div>
        </div>
    </div>

    {{-- History Tags --}}
    @if(isset($historySummary) && $historySummary->isNotEmpty())
        <div class="flex gap-2 overflow-x-auto pb-2 mb-4 scrollbar-hide">
            @foreach($historySummary as $summary)
                <div
                    class="flex-shrink-0 px-3 py-1.5 rounded-lg bg-[color:var(--emp-surface)] border border-[color:var(--emp-border)] text-[11px] text-[color:var(--emp-muted)] whitespace-nowrap shadow-sm">
                    <span class="font-bold text-[color:var(--emp-text)]">{{ $summary['month_label'] }}</span>
                    <span class="mx-1 text-slate-300">|</span>
                    Submitted: <span class="font-semibold text-emerald-600">₹ {{ number_format($summary['total']) }}</span>
                </div>
            @endforeach
        </div>
    @endif

    {{-- Stats row --}}
    <div class="grid sm:grid-cols-2 lg:grid-cols-3 gap-4 mb-6">

        {{-- Submitted this month --}}
        <div
            class="rounded-2xl bg-[color:var(--emp-surface)] border border-[color:var(--emp-border)] shadow-sm p-4 relative overflow-hidden">
            <div class="absolute top-0 left-0 right-0 h-1 bg-[color:var(--emp-brand)]"></div>
            <div class="text-[11px] font-semibold text-[color:var(--emp-muted)] uppercase tracking-[0.16em]">
                This Month (Submitted)
            </div>
            <div class="mt-2 text-2xl font-extrabold text-[color:var(--emp-text)]">
                ₹ {{ number_format($monthTotalSubmitted, 2) }}
            </div>
            <div class="mt-1 text-[11px] text-[color:var(--emp-muted)]">
                Total conveyance amount you have submitted in {{ $currentMonthLabel }}.
            </div>
        </div>

        {{-- Draft amount --}}
        <div
            class="rounded-2xl bg-[color:var(--emp-surface)] border border-[color:var(--emp-border)] shadow-sm p-4 relative overflow-hidden">
            <div class="absolute top-0 left-0 right-0 h-1 bg-slate-500/80"></div>
            <div class="text-[11px] font-semibold text-[color:var(--emp-muted)] uppercase tracking-[0.16em]">
                Draft Entries
            </div>
            <div class="mt-2 text-2xl font-extrabold text-[color:var(--emp-text)]">
                ₹ {{ number_format($monthTotalDraft, 2) }}
            </div>
            <div class="mt-1 text-[11px] text-[color:var(--emp-muted)]">
                Amount saved as draft, not yet submitted for {{ $currentMonthLabel }}.
            </div>
        </div>

        {{-- Claim window / placeholder --}}
        <div
            class="rounded-2xl bg-[color:var(--emp-surface)] border border-[color:var(--emp-border)] shadow-sm p-4 relative overflow-hidden">
            <div class="absolute top-0 left-0 right-0 h-1 bg-emerald-500/80"></div>
            <div class="text-[11px] font-semibold text-[color:var(--emp-muted)] uppercase tracking-[0.16em]">
                Claim Window
            </div>
            <div class="mt-2 text-base font-semibold text-[color:var(--emp-text)]">
                {{ $monthStart->format('d M Y') }} – {{ $monthEnd->format('d M Y') }}
            </div>
            <div class="mt-1 text-[11px] text-[color:var(--emp-muted)]">
                Entries allowed for this month, and editable till the 10th of next month.
            </div>
        </div>
    </div>

    {{-- Bottom section --}}
    <div class="grid lg:grid-cols-2 gap-4">

        <div class="rounded-2xl bg-[color:var(--emp-surface)] border border-[color:var(--emp-border)] shadow-sm p-4">
            <h3 class="text-sm font-semibold mb-2">Quick Actions</h3>
            <div class="space-y-2 text-sm">
                <a href="{{ route('employee.conveyance.create') }}"
                    class="block px-3 py-2 rounded-xl bg-[color:var(--emp-bg-soft)] hover:bg-slate-100 border border-[color:var(--emp-border)] font-semibold">
                    Add today&apos;s conveyance →
                </a>
                <a href="{{ route('employee.conveyance.index') }}"
                    class="block px-3 py-2 rounded-xl bg-white hover:bg-slate-50 border border-[color:var(--emp-border)] text-xs">
                    Review this month&apos;s entries →
                </a>
            </div>
        </div>

        <div class="rounded-2xl bg-[color:var(--emp-surface)] border border-[color:var(--emp-border)] shadow-sm p-4">
            <h3 class="text-sm font-semibold mb-2">Guidelines</h3>
            <ul class="text-xs text-[color:var(--emp-muted)] space-y-1.5">
                <li>• Add travel entries daily or at least once a week.</li>
                <li>• Only dates from current month ({{ $currentMonthLabel }}) are allowed in this sheet.</li>
                <li>• Editing is open till the 10th of next month for draft entries.</li>
                <li>• For round trips, use the “Return trip” checkbox while adding entries.</li>
            </ul>
        </div>

    </div>

@endsection