@extends('layouts.employee')

@section('page-title', 'Expense Groups')
@section('page-subtitle', 'Create and manage your personal expense categories')

@section('content')

<div class="mb-6 flex flex-col md:flex-row md:items-center md:justify-between gap-4">
    <div>
        <h2 class="text-xl md:text-2xl font-extrabold tracking-tight">Expense Groups</h2>
        <p class="text-sm text-[color:var(--emp-muted)] mt-1">
            Create groups like <span class="font-semibold">Travel, Food, Client Visit</span> and use them while adding expenses.
        </p>
    </div>

    <a href="{{ route('employee.expenses.create') }}"
       class="inline-flex items-center px-4 py-2 rounded-xl bg-[color:var(--emp-brand)] text-white text-xs md:text-sm font-semibold shadow-sm hover:bg-blue-700 transition">
        Add Expenses
    </a>
</div>

{{-- Flash messages --}}
@if(session('success'))
    <div class="mb-4 rounded-2xl border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-800">
        {{ session('success') }}
    </div>
@endif

@if($errors->any())
    <div class="mb-4 rounded-2xl border border-rose-200 bg-rose-50 px-4 py-3 text-sm text-rose-800">
        <ul class="list-disc pl-5 space-y-1">
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<div class="rounded-3xl bg-[color:var(--emp-surface)] border border-[color:var(--emp-border)] shadow-sm p-5 mb-6">
    <div class="mb-4">
        <h3 class="text-lg md:text-xl font-semibold">Add New Group</h3>
        <p class="text-xs md:text-sm text-[color:var(--emp-muted)] mt-1">
            Group names should be short and meaningful, such as <em>Travel</em>, <em>Hotel</em>, <em>Fuel</em>, <em>Client Visit</em>.
        </p>
    </div>

    <form action="{{ route('employee.expense-groups.store') }}" method="POST" class="flex flex-col md:flex-row gap-3 md:items-center">
        @csrf
        <div class="flex-1">
            <input type="text"
                   name="name"
                   value="{{ old('name') }}"
                   placeholder="e.g. Travel"
                   class="w-full rounded-xl border border-[color:var(--emp-border)] bg-white px-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-[color:var(--emp-brand)]">
        </div>
        <button type="submit"
                class="px-4 py-2 rounded-xl bg-[color:var(--emp-brand)] text-white text-xs md:text-sm font-semibold hover:bg-blue-700 transition shadow-sm">
            Add Group
        </button>
    </form>
</div>

<div class="rounded-3xl bg-[color:var(--emp-surface)] border border-[color:var(--emp-border)] shadow-sm p-5">
    <div class="mb-4 flex items-center justify-between">
        <h3 class="text-sm md:text-base font-semibold">Your Groups</h3>
        <span class="text-[11px] text-[color:var(--emp-muted)]">
            Total: <span class="font-semibold">{{ $groups->count() }}</span>
        </span>
    </div>

    @if($groups->isEmpty())
        <p class="text-xs text-[color:var(--emp-muted)]">
            No groups yet. Add your first group using the form above.
        </p>
    @else
        <div class="overflow-x-auto">
            <table class="min-w-full text-sm">
                <thead class="bg-slate-50 text-[11px] uppercase tracking-wide text-[color:var(--emp-muted)]">
                    <tr>
                        <th class="px-3 py-2 text-left font-semibold">Group Name</th>
                        <th class="px-3 py-2 text-left font-semibold w-32">Status</th>
                        <th class="px-3 py-2 text-left font-semibold w-40">Created</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-[color:var(--emp-border)] bg-white">
                    @foreach($groups as $group)
                        <tr>
                            <td class="px-3 py-2">
                                <span class="text-[13px] text-[color:var(--emp-text)] font-medium">
                                    {{ $group->name }}
                                </span>
                            </td>
                            <td class="px-3 py-2">
                                @if($group->is_active)
                                    <span class="inline-flex items-center rounded-full bg-emerald-50 px-2.5 py-0.5 text-[11px] font-semibold text-emerald-700 border border-emerald-200">
                                        Active
                                    </span>
                                @else
                                    <span class="inline-flex items-center rounded-full bg-slate-100 px-2.5 py-0.5 text-[11px] font-semibold text-slate-600 border border-slate-200">
                                        Inactive
                                    </span>
                                @endif
                            </td>
                            <td class="px-3 py-2 text-[11px] text-[color:var(--emp-muted)]">
                                {{ $group->created_at?->format('d M Y, H:i') ?? '-' }}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @endif
</div>

@endsection
