{{-- resources/views/employee/expenses/show.blade.php --}}
@extends('layouts.employee')

@section('page-title', 'Expense Details')
@section('page-subtitle', 'View full details of this expense')

@section('content')
@php
    $files = [];
    if (isset($expense->proof_paths) && is_array($expense->proof_paths)) {
        $files = $expense->proof_paths;
    } elseif ($expense->proof_path) {
        $files = [['path' => $expense->proof_path, 'original_name' => $expense->proof_original_name]];
    }
@endphp

<div class="max-w-4xl mx-auto p-6">
    <div class="rounded-3xl bg-[color:var(--emp-surface)] border border-[color:var(--emp-border)] shadow-lg">
        {{-- Header --}}
        <div class="px-5 py-4 border-b border-[color:var(--emp-border)] flex items-start justify-between gap-3">
            <div>
                <h3 class="text-xl font-bold text-[color:var(--emp-text)]">
                    {{ $expense->group ?? 'Expense' }}
                </h3>
                <p class="text-sm text-[color:var(--emp-muted)] mt-1">
                    {{ $expense->expense_date->format('d M Y') }}
                    @if($expense->financialSession)
                        • {{ $expense->financialSession->name }}
                    @endif
                </p>
                <p class="text-xs text-[color:var(--emp-muted)] mt-1">
                    Created: {{ $expense->created_at->format('d M Y, h:i A') }}
                </p>
            </div>
            <div class="text-right">
                <div class="text-lg font-semibold text-[color:var(--emp-brand)]">
                    ₹ {{ number_format($expense->amount, 2) }}
                </div>
            </div>
        </div>

        {{-- Body --}}
        <div class="px-5 py-5 space-y-4">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                <div>
                    <div class="text-[11px] font-semibold text-[color:var(--emp-muted)] uppercase tracking-[0.12em]">
                        Group
                    </div>
                    <div class="mt-1 text-[color:var(--emp-text)]">
                        {{ $expense->group ?? '-' }}
                    </div>
                </div>

                <div>
                    <div class="text-[11px] font-semibold text-[color:var(--emp-muted)] uppercase tracking-[0.12em]">
                        Party Name
                    </div>
                    <div class="mt-1 text-[color:var(--emp-text)]">
                        {{ $expense->party_name ?? '-' }}
                    </div>
                </div>

                <div>
                    <div class="text-[11px] font-semibold text-[color:var(--emp-muted)] uppercase tracking-[0.12em]">
                        Session
                    </div>
                    <div class="mt-1 text-[color:var(--emp-text)]">
                        {{ $expense->financialSession->name ?? '-' }}
                    </div>
                </div>

                <div>
                    <div class="text-[11px] font-semibold text-[color:var(--emp-muted)] uppercase tracking-[0.12em]">
                        Entered On
                    </div>
                    <div class="mt-1 text-[color:var(--emp-text)]">
                        {{ $expense->created_at->diffForHumans() }}
                    </div>
                </div>
            </div>

            <div>
                <div class="text-[11px] font-semibold text-[color:var(--emp-muted)] uppercase tracking-[0.12em]">
                    Purpose
                </div>
                <div class="mt-1 text-sm text-[color:var(--emp-text)] leading-relaxed">
                    {{ $expense->purpose ?? '-' }}
                </div>
            </div>

            {{-- Proof files --}}
            <div>
                <div class="text-[11px] font-semibold text-[color:var(--emp-muted)] uppercase tracking-[0.12em] mb-1.5">
                    Attachments
                </div>

                @if(count($files))
                    <div class="space-y-2">
                        @foreach($files as $i => $file)
                            <div class="flex items-center justify-between gap-3 rounded-xl border border-[color:var(--emp-border)] bg-white px-3 py-2">
                                <div class="truncate text-sm text-[color:var(--emp-text)]">
                                    {{ $file['original_name'] ?? basename($file['path']) }}
                                </div>
                                <a href="{{ route('employee.expenses.download', $expense) }}?file={{ urlencode($file['path']) }}"
                                   class="text-xs px-3 py-1.5 rounded-xl border border-[color:var(--emp-border)] bg-[color:var(--emp-bg-soft)] hover:bg-slate-100">
                                    Download
                                </a>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-xs text-[color:var(--emp-muted)]">No attachments uploaded.</div>
                @endif
            </div>
        </div>

        {{-- Footer --}}
        <div class="px-5 py-3 border-t border-[color:var(--emp-border)] flex items-center justify-between">
            <a href="{{ route('employee.expenses.index') }}"
               class="text-xs md:text-sm text-[color:var(--emp-muted)] hover:text-[color:var(--emp-text)]">
                ← Back to expenses
            </a>
            <a href="{{ route('employee.expenses.edit', $expense) }}"
               class="px-3 py-2 rounded-xl border text-xs md:text-sm text-[color:var(--emp-text)] hover:bg-slate-50">
                Edit Expense
            </a>
        </div>
    </div>
</div>
@endsection
