@extends('layouts.employee')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-amber-50 to-white py-8">

    <div class="max-w-4xl mx-auto bg-white border border-amber-200 rounded-lg">

        <!-- Header -->
        <div class="px-6 py-4 border-b border-amber-200 flex items-center justify-between
                    bg-gradient-to-r from-amber-100 to-amber-50">
            <div>
                <h2 class="text-base font-semibold text-amber-900">
                    Apply Leave
                </h2>
                <p class="text-sm text-amber-700">
                    Please select the leave duration and provide details
                </p>
            </div>


        </div>

        <!-- Form -->
        <form class="px-6 py-6" action="{{ route('employee.leaves.store') }}" method="POST">
            @csrf
            <!-- From - To - Approved By (ONE ROW) -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">

                <!-- From Date -->
                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-1">
                        From Date
                    </label>
                    <input type="date" name="start_date" class="w-full rounded-md border border-amber-300
                                  px-3 py-2 text-sm text-slate-800
                                  focus:border-amber-500 focus:ring-1 focus:ring-amber-500">
                </div>

                <!-- To Date -->
                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-1">
                        To Date
                    </label>
                    <input type="date" name="end_date" class="w-full rounded-md border border-amber-300
                                  px-3 py-2 text-sm text-slate-800
                                  focus:border-amber-500 focus:ring-1 focus:ring-amber-500">
                </div>

                <!-- Approved By -->
                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-1">
                        Approved By
                    </label>
                    <input type="text" name="approved_by" placeholder="Reporting Manager / HR" class="w-full rounded-md border border-amber-300
                                  px-3 py-2 text-sm text-slate-800
                                  focus:border-amber-500 focus:ring-1 focus:ring-amber-500">
                </div>

            </div>

            <!-- Remark -->
            <div class="mt-6">
                <label class="block text-sm font-medium text-slate-700 mb-1">
                    Remark <span class="text-slate-400">(optional)</span>
                </label>
                <textarea rows="3" name="reason" placeholder="Add reason or any note" class="w-full rounded-md border border-amber-300
                                 px-3 py-2 text-sm text-slate-800
                                 focus:border-amber-500 focus:ring-1 focus:ring-amber-500"></textarea>
            </div>

            <!-- Actions -->
            <div class="flex justify-end gap-3 mt-8 pt-4 border-t border-amber-200">

                <button type="button" class="px-4 py-2 text-sm rounded-md border border-slate-300
                               text-slate-700 hover:bg-slate-100 transition">
                    Cancel
                </button>

                <button type="submit" class="px-5 py-2 text-sm rounded-md font-medium text-white
                               bg-amber-600 hover:bg-amber-700
                               focus:ring-2 focus:ring-amber-400 focus:ring-offset-1
                               transition">
                    Submit Leave
                </button>

            </div>

        </form>
    </div>
</div>
@endsection